# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk import environments


class StartrekDataManager(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        description = sdk2.parameters.String('', required=False)
        max_restarts = 2
        kill_timeout = 3600
        dump_disk_usage = False
        fail_on_any_error = True

        st_token = sdk2.parameters.YavSecret('OAuth ST token', required=True)
        yt_token = sdk2.parameters.YavSecret('OAuth YT token', required=True)

        tags = ['ST', 'DataManager']

    class Requirements(sdk2.Requirements):
        ram = 2048
        cores = 2
        disk_space = 100

        environments = [
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('startrek_client', version='2.5',
                                        custom_parameters=['--upgrade-strategy', 'only-if-needed'])
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        from sandbox.projects.MarketQC.yt_data_manager.startrek_manager.lib import run

        st_token = self.Parameters.st_token.data()[self.Parameters.st_token.default_key]
        yt_token = self.Parameters.yt_token.data()[self.Parameters.yt_token.default_key]

        run(st_token=st_token, yt_token=yt_token)
