# coding: utf-8

import json
import urllib2

import sandbox.common.types.misc as ctm
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common import apihelpers

bad_models = {'hs', 'ace', 'aceca', 'cobra', 'el', 'mdx', 'rl', 'rsx', 'slx', 'tl', '145', '146', '147', '155', '156',
              '159', '164', '166', '33', '75', '90', 'gt', 'gtv', 'spider', 'b10', 'b11', 'b12', 'b3', 'b7', 'b8',
              'd10', 'd3', 'gta', '24', 'retona', 'v12', 'v8', '100', '200', '80', '90', 'a2', 'a4', 'a5', 'a6', 'a8',
              'coupe', 'r8', 's2', 's3', 's4', 's5', 's6', 's7', 's8', 'tt', 'tts', 'v8', 'allegro', 'metro',
              'princess', 'continental', 'flying spur', 'turbo r', '2', '1er', '2er', '315', '3200', '340', '3er', '4',
              '503', '5er', '600', '6er', '700', '7er', '8er', 'm2', 'm3', 'm4', 'm5', 'm6', 'z3', 'z8', '2000', 'h530',
              'm2 bs4', 'm3 bc3', 'v5', 'fighter', 'ris', 'century', 'electra', 'gl8', 'lucerne', 'park avenue',
              'regal', 'rendezvous', 'riviera', 'special', 'super', 'f3', 'f6', 'flyer', 'g3', 'g6', 'm6', 's6', 'ats',
              'catera', 'cts', 'de ville', 'dts', 'eldorado', 'fleetwood', 'seville', 'sts', 'c21', 'cs35', 'eado',
              'cs6', 'flying', 'amulet', 'bonus', 'fora', 'kimo', 'oriental son', 'qq', 'very', 'astro', 'avalanche',
              'aveo', 'beretta', 'blazer', 'bolt', 'caprice', 'cavalier', 'celta', 'ck', 'classic', 'colorado',
              'corsica', 'deluxe', 'express', 'hhr', 'malibu', 'master', 'metro', 'monte carlo', 'monza', 'niva',
              'prizm', 's 10', 'silverado', 'sonic', 'spark', 'ss', 'ssr', 'starcraft', 'tracker', 'transsport', 'van',
              'viva', 'volt', '200', '300', '300c', 'aspen', 'cirrus', 'concorde', 'crossfire', 'dynasty', 'neon',
              'new yorker', 'vision', 'voyager', 'ax', 'bx', 'cx', 'nemo', 'visa', 'xm', 'zx', '1310', '1410', 'dokker',
              'nova', 'shuttle', 'arcadia', 'chairman', 'le mans', 'prince', 'racer', 'sens', 'tosca', '46', '66',
              'altis', 'be go', 'coo', 'esse', 'materia', 'max', 'mira', 'move', 'naked', 'opti', 'rocky', 'xenia',
              'yrv', 'xjs', '720', 'go', 'sunny', 'pantera', 'antelope', 'aurora', 'cowboy', 'shuttle', '600',
              'avenger', 'dakota', 'dynasty', 'journey', 'monaco', 'neon', 'nitro', 'omni', 'ram', 'shadow', 'spirit',
              'stealth', 'rich', 's30', 'assol', 'kondor', 'orion', 'd8', '4', 'premier', 'summit', 'vision', 'ss',
              'besturn b70', 'jinn', 'v5', 'vita', '328', '348', '360 modena', '412', '456', '512m', '550',
              '575 maranello', '612 scaglietti', 'california', 'f355', 'f40', 'f430', 'f50', 'mondial', '124', '126',
              '127', '131', '500', '600', 'brava', 'bravo', 'coupe', 'croma', 'duna', 'idea', 'palio', 'panda', 'punto',
              'regata', 'ritmo', 'siena', 'stilo', 'tipo', 'ulysse', 'uno', 'x 1 9', 'aerostar', 'aspire', 'b max',
              'capri', 'consul', 'contour', 'edge', 'escape', 'escort', 'everest', 'explorer', 'f 150', 'five hundred',
              'flex', 'focus st', 'freestyle', 'fusion', 'galaxy', 'granada', 'gt', 'ka', 'laser', 'orion', 'probe',
              'puma', 'scorpio', 'tempo', 'thunderbird', 'tourneo custom', 'laser', 'midi', 'sauvana', 'land king',
              '12', '13', '14', '21', '22', '2308 ataman', '2330 tigr', '24', '3110', '67', '69', 'm 20', 'ck', 'mk',
              'sc7', 'vision', 'metro', 'prizm', 'storm', 'acadia', 'jimmy', 'safari', 'savana', 'yukon', 'roadster',
              'cowry', 'deer', 'hover m2', 'hoverh3', 'pegasus', 'peri', 'safe', 'sailor', 'sing', 'socool', 'princip',
              'sigma', '3', '7', 'm3', 's5', 'h2', 'commodore', 'rodeo', 'accord', 'airwave', 'ascot', 'beat', 'capa',
              'city', 'concerto', 'cr v', 'domani', 'element', 'fit', 'inspire', 'jazz', 'legend', 'life', 'logo',
              'odyssey', 'partner', 'passport', 'pilot', 's mx', 'shuttle', 'stream', 'thats', 'today', 'vamos',
              'vigor', 'z', 'zest', 'antelope', 'landscape', 'h1', 'h2', 'h3', 'atos', 'avante', 'coupe', 'dynasty',
              'excel', 'genesis', 'getz', 'h 1 starex', 'i40', 'ix35', 'matrix', 'pony', 'xg', '2125', '2126', '2717',
              'ex', 'g35', 'i', 'j30', 'jx', 'm', 'q', 'qx4', 'qx56', 'elba', 'mini', 's1', 'samand', 'spyder', 'amigo',
              'aska', 'axiom', 'gemini', 'kb', 'mu', 'mu-7', 'rodeo', 'tf', 'wizard', 's 3', 's5', 'e type', 'f type',
              'mark 2', 'xf', 'xj', 'xj220', 'xjr', 'xjs', 'xk', 'cj', 'commander', 'compass', 'patriot', 'wrangler',
              'capital', 'ceed', 'concord', 'elan', 'enterprise', 'mohaves', 'pride', 'retona', 'sedona', 'sephia',
              'soul', 'spectra', 'ccr', 'one 1', 't98', 'diablo', 'delta', 'gamma', 'kappa', 'montecarlo', 'musa',
              'prisma', 'thema', 'voyager', 'ypsilon', 'zeta', 'discovery', 'freelander', 'range rover', 'forward',
              'es', 'gx', 'is', 'ls', 'lx', 'nx', 'sc', 'leopard', 'breez', 'smily', 'x60', 'aviator', 'capri',
              'continental', 'ls', 'mks', 'navigator', '340r', 'elan', 'elise', 'esprit', 'excel', 'tx', '1302', '967',
              '969', 'armada', 'commander', 'marshal', 'mm', 'voyager', '1000', '800', 'alto', 'gypsy', 'omni', 'zen',
              '228', '3200gt', '420', 'bora', 'levante', '57', '62', '1000', '121', '2', '3', '323', '5', '6', '626',
              '929', 'axela', 'bongo', 'bongo friendee', 'capella', 'carol', 'cosmo', 'cronos', 'familia', 'luce',
              'mx 3', 'persona', 'premacy', 'protege', 'scrum', 'tribute', '650s', 'f1', 'club', 'monte carlo', 'track',
              'viano', 'vito', 'w123', 'w124', 'capri', 'mystique', 'sable', 'topaz', 'tracer', '3', '5', '550', '6',
              '750', 'f', 'metro', 'tf', 'zr', 'zs', 'zt', 'mc', 'cabrio', 'countryman', 'coupe', 'hatch', 'roadster',
              '3000 gt', 'airtrek', 'aspire', 'asx', 'carisma', 'delica', 'diamante', 'dingo', 'eclipse', 'ek',
              'eterna', 'i', 'libero', 'mirage', 'outlander', 'pajero io', 'raider', 'rvr', 'sigma', 'space gear',
              '4 4', 'plus 4', 'plus 8', 'eight', 'marina', '2137', '2138', '400', '401', '402', '403', '408', '410',
              '424', '426', '427', 'knyaz vladimir', 'svyatogor', '370z', 'ad', 'armada', 'avenir', 'bluebird',
              'caravan coach', 'cherry', 'cima', 'crew', 'cube', 'expert', 'figaro', 'gloria', 'juke', 'leopard',
              'liberty', 'lucino', 'march', 'mistral', 'moco', 'note', 'nv200', 'otti', 'patrol', 'president',
              'primera', 'pulsar', 'quest', 'rnessa', 'rogue', 'safari', 'serena', 'skyline', 'sunny', 'teana', 'titan',
              'aurora', 'eighty eight', 'ninety eight', 'admiral', 'ascona', 'astra', 'campo', 'combo', 'commodore',
              'gt', 'manta', 'monza', 'olympia', 'rekord', 'senator', 'speedster', 'tigra', 'vita', 'one twenty',
              'viva', '2008', '201', '204', '205', '208', '301', '305', '402', '403', '406', '407', '408', '504', '505',
              '604', '806', '807', 'expert', 'ion', 'partner', 'porter', 'breeze', 'caravelle', 'laser', 'neon',
              'voyager', 'aztek', 'g5', 'g6', 'g8', 'grand am', 'grand prix', 'gto', 'lemans', 'montana', 'phoenix',
              'torrent', 'vibe', '911', '924', '928', '944', '968', 'persona', 'gtb', '3', 'mangusta', 'r2', '10', '11',
              '12', '14', '18', '19', '21', '25', '30', '5', '6', '8', '9', 'modus', 'rodeo', 'safrane', 'trafic',
              'twingo', 'ghost', 'park ward', '100', '200', '25', '400', '45', '600', '75', '800', 'metro', 'mini',
              '9 5', '90', '900', '9000', '95', '99', 's7', 'ion', 'ls', 'lw', 'outlook', 'sky', 'sl', 'vue', 'tc',
              'xa', 'xb', 'arosa', 'cordoba', 'leon', 'marbella', 'ronda', 'toledo', 'c8', 'chairman', '360', 'baja',
              'brz', 'justy', 'leone', 'libero', 'pleo', 'r1', 'r2', 'stella', 'svx', 'xv', 'aerio', 'alto',
              'cappuccino', 'equator', 'every', 'jimny', 'kei', 'reno', 'samurai', 'twin', 'verona', 'c30', '1510',
              'horizon', 'aria', 'indica', 'safari', '80', 't613', 't700', 'model x', 'roadster', 'century', 'admiral',
              'murat 124', 'sahin', 'allex', 'allion', 'alphard', 'altezza', 'aristo', 'avalon', 'bb', 'belta', 'blade',
              'blizzard', 'brevis', 'caldina', 'cami', 'cavalier', 'century', 'chaser', 'cresta', 'crown', 'duet',
              'echo', 'estima', 'funcargo', 'gaia', 'gt86', 'harrier', 'hilux', 'hilux surf', 'iq', 'isis', 'ist',
              'matrix', 'mr2', 'nadia', 'noah', 'opa', 'origin', 'passo', 'picnic', 'platz', 'porte', 'premio',
              'probox', 'progres', 'raum', 'rush', 'sequoia', 'sera', 'sienna', 'sparky', 'sprinter', 'sprinter marino',
              'starlet', 'succeed', 'vista', 'vitz', 'wish', '601', '350', '400', '420', 'griffith', 'tuscan', '3159',
              '469', 'victor', 'viva', '1111', 'beetle', 'bora', 'california', 'caravelle', 'eos', 'fox', 'lupo',
              'santana', 'taro', 'up', 'vento', '140', '164', '240 series', '260', '300 series', '440', '460', '480',
              '66', '760', '780', '850', '940', '960', '1 3', '353', 'gt', 'roadster', 'pickup x3', '10', '965', '966',
              '968', 'chance', 'dana', 'sens', 'slavuta', 'tavria', 'vida', 'e10', '111', '114', '117', '101',
              'admiral', 'landmark', 'cl', 'rdx', 'tsx', 'db9', 'dbs', 'a1', 'a3', 'a7', 'i3', 'i8', 'c1', 'c2', 'c3',
              'c4', 'c5', 'c6', '458', '488', 'insight', 'g', 'ct', 'gs', 'gs f', 'lc', 'rc', 'mkt', 'mkz', 'leaf',
              '1007', 'up', 'fx'}

bad_models_matched = set()


def get_translit(key):
    result = []
    if "'" in key:
        new_key = key.replace("'", '')
        result.append(new_key)
        result += get_translit(new_key)
    url = 'http://hamzard.yandex.net:8891/wizard?text=%s&format=json' % key.replace(' ', '+')
    print 'fetching', url
    data = urllib2.urlopen(url).read()
    j = json.loads(data)
    markup = j['markup']
    if 'Extensions' in markup:
        for e in markup['Extensions']:
            if e['Type'] == 'TE_TRANSLIT':
                result.append(e['ExtendTo'].encode('utf-8'))
    return [i for i in list(set(result)) if len(i) > 2]


def is_bad_model(model):
    result = model.lower() in bad_models
    if result:
        bad_models_matched.add(model.lower())
    return result


def process_raw_data(input_fn):
    result_filename = 'marks.txt'
    with open('marks.txt', 'w') as marks:
        marks.write("""encoding "utf8";
        import "search/wizard/rules/proto/market_tires.gztproto";

        TGztOptions { DefaultKey = { normalize = { mode = FULL  } } }

        TMarketTiresKeyWordArticle { key={ "шина" | "автошина" | "резина" | "авторезина" | "покрышка" | "автопокрышка" } }

        """)

        data = json.load(open(input_fn))['__data__']
        for item in data:
            if '__chaptername__' not in item:
                continue
            if item['__chaptername__'] != 'marks':
                continue

            for c in item['__chapters__']:
                mark = c['__attrm__']['name'].encode('utf-8')
                keys = get_translit(mark) + [mark]
                marks.write(
                    'TMarketTiresMarkArticle {\n    key={%s},\n    Mark="%s"\n}\n\n' % (
                        ' | '.join('"' + key + '"' for key in keys),
                        mark
                    )
                )
                for m in c['__chapters__']:
                    model = m['__attrm__']['name'].encode('utf-8')
                    mkeys = get_translit(model) + [model]
                    marks.write(
                        'TMarketTiresModelArticle {\n    key={%s},\n    Model="%s",\n    Mark="%s"%s\n}\n\n' % (
                            ' | '.join('"' + key + '"' for key in mkeys),
                            model,
                            mark,
                            ',\n    IsTrusted=true' if not is_bad_model(model) else ''
                        )
                    )

    return result_filename


class MarketWizardTires(SandboxTask):
    type = 'MARKET_WIZARD_TIRES'
    dns = ctm.DnsType.DNS64

    def on_execute(self):
        if 'data_build' not in self.ctx:
            self.ctx['data_build'] = self.create_subtask(
                task_type='BUILD_MARKET_GURU_ASSISTANT_DATA',
                description='build raw tires data for wizard'
            ).id
            self.wait_task_completed(self.ctx['data_build'])

        raw_tires_data_id = apihelpers.get_task_resource_id(
            task_id=self.ctx['data_build'],
            resource_type='MARKET_GURU_ASSISTANT_DATA',
        )

        path = self.sync_resource(raw_tires_data_id)
        run_process('tar -xvzf ' + path, shell=True)
        run_process('gunzip guruassistant/tires_54469.json.gz')

        self.create_resource(
            description='data for market tires wizard',
            resource_path=process_raw_data('guruassistant/tires_54469.json'),
            resource_type='OTHER_RESOURCE',
        )

        self.ctx['bad_models_matched'] = list(bad_models_matched)
        self.ctx['bad_models_not_matched'] = [m for m in bad_models if m not in bad_models_matched]


__Task__ = MarketWizardTires
