# -*- coding: utf-8 -*-

import copy

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.paths import copy_path

from sandbox.projects.common.nanny import nanny
from sandbox.projects.common import apihelpers


class SrcResource(SandboxStringParameter):
    name = 'src_resource_id'
    description = 'Sandbox resource (source)'
    required = True


class DstResourceType(SandboxStringParameter):
    name = 'dst_resource_type'
    description = 'Sandbox resouce (destination)'
    required = True


class MediaCopySandboxResource(nanny.ReleaseToNannyTask, SandboxTask):

    type = 'MEDIA_COPY_SANDBOX_RESOURCE'

    cores = 1

    input_parameters = [
        SrcResource,
        DstResourceType
    ]

    def _copy_resource(self, resource_id, new_resource_type):
        resource = channel.sandbox.get_resource(resource_id)
        src_path = self.sync_resource(resource.id)
        dst_path = resource.file_name
        copy_path(src_path, dst_path)

        attributes = copy.copy(resource.attributes)
        attributes.pop('released', None)
        created_resource = self.create_resource(
            resource.description, dst_path, new_resource_type, arch=resource.arch, attributes=attributes)
        self.mark_resource_ready(created_resource)
        return created_resource.id

    def on_execute(self):
        new_resouce = apihelpers.get_last_resource(self.ctx[SrcResource.name])
        self.ctx['new_shardmap'] = channel.sandbox.get_resource_attribute(new_resouce.id, 'shardmap_timestamp')
        current_resouce = apihelpers.get_last_resource(self.ctx[DstResourceType.name])
        self.ctx['curr_shardmap'] = channel.sandbox.get_resource_attribute(current_resouce.id, 'shardmap_timestamp')
        if self.ctx['new_shardmap'] > self.ctx['curr_shardmap']:
            self._copy_resource(new_resouce.id, self.ctx[DstResourceType.name])
            self.create_subtask(
                task_type="DEPLOY_NANNY_DASHBOARD",
                input_parameters={
                    'deployment_task_id': self.id,
                    'deployment_nanny_dashboard_name': 'thumbnails_images_quick',
                    'deployment_nanny_dashboard_recipe': 'db_switch',
                    'deployment_nanny_dashboard_filter': 'stable',
                    'deployment_release_status': 'testing',
                },
                description='{}'.format(self.descr.encode('UTF-8')),
            )


__Task__ = MediaCopySandboxResource
