# -*- coding: utf-8 -*-
"""
You must install additional module 'shard_tracker':
    class MyClass(SandboxTask):
        environment = (environments.PipEnvironment('shard_tracker'),)
"""

from sandbox.sandboxsdk.environments import PipEnvironment

SHARDTRACKER = ('shardtracker.search.yandex.net', 9100)


class iss_shardtracker_api:
    """
    Shard tracker thrift API
    """

    def __init__(self, shardtracker=SHARDTRACKER):
        PipEnvironment('shard_tracker').prepare()
        PipEnvironment('thrift').prepare()

        self.shardtracker = shardtracker

    def __enter__(self):
        from shard_tracker import ShardTrackerService
        from thrift.protocol import TBinaryProtocol
        from thrift.transport import TSocket, TTransport
        self.transport = TSocket.TSocket(self.shardtracker[0], self.shardtracker[1])
        self.transport = TTransport.TFramedTransport(self.transport)
        protocol = TBinaryProtocol.TBinaryProtocol(self.transport)
        self.transport.open()
        return ShardTrackerService.Client(protocol)

    def __exit__(self, type, value, traceback):
        self.transport.close()
