# -*- coding: utf-8 -*-

from kazoo.client import KazooClient

ZK_HOSTS = ('zookeeper1.search.yandex.net:2181,'
            'zookeeper2.search.yandex.net:2181,'
            'zookeeper3.search.yandex.net:2181,'
            'zookeeper4.search.yandex.net:2181,'
            'zookeeper5.search.yandex.net:2181')

MEDIA_ZK_HOSTS = ('media-zookeeper1.search.yandex.net:2281,'
                  'media-zookeeper2.search.yandex.net:2281,'
                  'media-zookeeper3.search.yandex.net:2281,'
                  'media-zookeeper4.search.yandex.net:2281,'
                  'media-zookeeper5.search.yandex.net:2281,'
                  'media-zookeeper6.search.yandex.net:2281,'
                  'media-zookeeper7.search.yandex.net:2281,'
                  'media-zookeeper8.search.yandex.net:2281,'
                  'media-zookeeper9.search.yandex.net:2281')


class ZkFunctions(object):
    @staticmethod
    def set_forced(zk, node, value, makepath=True):
        if not zk.exists(node):
            zk.create(node, makepath)
        zk.set(node, value)


class MediaZkClient(object):
    def __enter__(self):
        self.kz = KazooClient(hosts=MEDIA_ZK_HOSTS, read_only=False)
        self.kz.start()
        return self.kz

    def __exit__(self, type, value, traceback):
        self.kz.stop()


class zk_client(object):
    def __enter__(self):
        self.kz = KazooClient(hosts=ZK_HOSTS, read_only=False)
        self.kz.start()
        return self.kz

    def __exit__(self, type, value, traceback):
        self.kz.stop()
