# -*- coding: utf-8 -*-

import json
import requests
import logging

from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common import apihelpers
from sandbox.projects.common.decorators import retries


logger = logging.getLogger()

YDL_HOST = 'ydl.n.yandex-team.ru'

RETRIES = 3
DELAY = 2


@retries(max_tries=RETRIES, delay=DELAY, exceptions=Exception)
def make_request(api_key, data):
    headers = {
        'Authorization': 'ApiKey {}'.format(api_key),
        'Content-Type': 'application/json'
    }

    response = requests.post('https://{}/api/v1/event'.format(YDL_HOST),
                              headers=headers, data=json.dumps(data),
                              verify=False)
    logger.debug('response: {}'.format(response))
    logger.debug('response text: {}'.format(response.text))
    logger.debug('data: {}'.format(data))
    response.raise_for_status()


def set_shardmap_point(api_key, store_shardmap_task_id, switch_type, text):

    list_resources = apihelpers.list_task_resources(
        task_id=store_shardmap_task_id,
        attribute_name='shardmap_name',
        limit=1,
        status='READY'
    )
    logger.debug("list_resources: %s", list_resources)

    shardmap_resource = channel.sandbox.get_resource(list_resources[0].id)
    shardmap_name = shardmap_resource.attributes['shardmap_name']

    tags = [
        {'text': 'type:newdb_{}'.format(switch_type)},
        {'text': 'tl:stop'},
        {'text': 'sandbox-shardmap:{}:{}'.format(shardmap_resource.type, store_shardmap_task_id)},
    ]

    data = {
        'name': '{} shardmap: {}'.format(text, shardmap_name),
        'description': '{} shardmap: {}'.format(text, shardmap_name),
        'tags': tags,
        'level': 30,
    }

    make_request(api_key, data)
