import os

import sandbox.projects.balancer.resources as resource_types
from sandbox.projects.common.balancer_sepe.run_tests import MediaTestBalancer


class MediaTestCommercialBalancer(MediaTestBalancer):
    type = 'MEDIA_TEST_COMMERCIAL_BALANCER'

    @staticmethod
    def _get_gencfg_dir():
        return "imgs-commercial"

    def _get_config_dir(self):
        return self.abs_path("imgs-commercial")

    def _get_config_resource_path(self, name):
        resource_map = {
            str(resource_types.BALANCER_COMMERCIAL_VLA_CONFIG): "imgs_commercial_vla.cfg",
            str(resource_types.BALANCER_COMMERCIAL_MAN_CONFIG): "imgs_commercial_man.cfg",
            str(resource_types.BALANCER_COMMERCIAL_SAS_CONFIG): "imgs_commercial_sas.cfg",
            str(resource_types.BALANCER_COMMERCIAL_HAMSTER_SAS_CONFIG): "imgs_commercial-hamster_sas.cfg",
            str(resource_types.BALANCER_COMMERCIAL_HAMSTER_MAN_CONFIG): "imgs_commercial-hamster_man.cfg"
        }
        return os.path.join(
            self._get_config_dir(),
            resource_map[name])

    @staticmethod
    def _get_config_names():
        return [
            resource_types.BALANCER_COMMERCIAL_VLA_CONFIG,
            resource_types.BALANCER_COMMERCIAL_MAN_CONFIG,
            resource_types.BALANCER_COMMERCIAL_SAS_CONFIG,
            resource_types.BALANCER_COMMERCIAL_HAMSTER_SAS_CONFIG,
            resource_types.BALANCER_COMMERCIAL_HAMSTER_MAN_CONFIG
        ]

    def _get_balancer_opts(self, http_port):
        if 'certs_path' not in self.ctx:
            self._prepare_certs()
        opts = {
            'SkipBindToServiceAddrs': 'True',
            'InstancePort': http_port
        }
        return opts

    def _get_tests(self):
        return {
            'stat_ruchka': {
                'desr': 'Statistic output',
                'func': self.check_stat_ruchka,
            },
            'shutdown': {
                'desr': 'Graceful shutdown',
                'func': self.graceful_shutdown,
            },
            'version': {
                'desr': 'Version ruchka',
                'func': self.check_version_ruchka,
            },
        }


__Task__ = MediaTestCommercialBalancer
