from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sdk2.helpers import subprocess
import logging
import os
import sys


class MollyReqs(sdk2.Resource):
    any_arch = True
    target_id = sdk2.parameters.String()


class MollyReqMiner(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('ipaddress'),
            environments.PipEnvironment('multipart', version='0.1'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings')
        )

    class Parameters(sdk2.Task.Parameters):
        target_id = sdk2.parameters.String('ServiceId from logs', required=True)
        target_hostname = sdk2.parameters.String('Target hostname. This value will change Host header', default="",
                                                 required=False)

    def on_execute(self):
        os.environ['YT_TOKEN'] = sdk2.Vault.data(self.owner, 'YtReqMinerToken')

        file_path = os.path.join(os.path.abspath(os.path.dirname(__file__)), 'generate.py')

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('main')) as pl:
            if self.Parameters.target_hostname:
                return_code = subprocess.Popen([sys.executable, file_path, self.Parameters.target_id,
                                                self.Parameters.target_hostname], stdout=pl.stdout,
                                               stderr=subprocess.STDOUT).wait()
            else:
                return_code = subprocess.Popen([sys.executable, file_path, self.Parameters.target_id],
                                               stdout=pl.stdout, stderr=subprocess.STDOUT).wait()

            if return_code == 0:
                logging.info('Subprocess ended successfully')
            else:
                logging.error('Subprocess ended with error: %s', return_code)
                raise Exception('Subprocess failed!')

        res = sdk2.ResourceData(MollyReqs(self, 'Output file', 'requests.json', target_id=self.Parameters.target_id))
        res.ready()
