#!/usr/bin/env python
# -*- coding: utf-8 -*-

import datetime
import os
import yt.wrapper as yt


class YtLogParser(object):
    """Abstract class for storing yt parameters"""

    def __init__(self, yt_server='hahn.yt.yandex.net', yt_token=None):
        """Sets standart parameters for yt providers
        :param yt_server:
        :param res_table:
        """
        self.yt = yt
        self.yt.config["auto_merge_output"]["action"] = "merge"
        self.yt.config['read_retries']['enable'] = True
        self.yt_server = yt_server
        self.yt.update_config({"proxy": {"url": yt_server}})
        # MacOS filtering
        yt.config['pickling']['module_filter'] = lambda module: hasattr(module, '__file__') and \
                                                                not module.__file__.endswith('.so') \
                                                                and 'hashlib' not in getattr(module, '__name__', '') \
                                                                and 'hmac' not in getattr(module, '__name__', '')

        if yt_token:
            self.yt.config["token"] = yt_token

        yt.config['pickling']['force_using_py_instead_of_pyc'] = True
        os.environ['YT_PROXY'] = self.yt_server


def get_date_list(date_from, date_to):
    """Returns list of dates for input range of dates
    :param date_to:
    :param date_from:
    """
    date_list = []
    for days_count in range(int((date_to - date_from).days) + 1):
        date_list.append((date_from + datetime.timedelta(days_count)).date())

    return date_list


def search_daily_tables(yt, start_datetime, end_datetime, table_prefix, dt_fmt='%Y-%m-%d', table_postfix=None):
    """Returns list of avaliable daily tables for range of datetime
    :param yt:
    :param start_datetime:
    :param end_datetime:
    :param table_prefix:
    :param dt_fmt:
    :param table_postfix:
    """
    yt_tables = []
    date_list = get_date_list(start_datetime, end_datetime)

    if table_postfix:
        input_tables = [table_prefix + date_item.strftime(dt_fmt) + table_postfix for date_item in date_list]

    else:
        input_tables = [table_prefix + date_item.strftime(dt_fmt) for date_item in date_list]

    for table_name in input_tables:
        if yt.exists(table_name):
            yt_tables.append(table_name)

    return yt_tables
