# coding: utf-8

import urllib
import requests
import logging

from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry


class Molly(object):
    ssl_verify = False  # Skynet, we look at you
    base_url = ''
    token = ''
    scan_id = ''

    def __init__(self, base_url, token):
        self.base_url = base_url
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(token)
        retry = Retry(
            total=3,
            backoff_factor=0.3,
        )
        adapter = HTTPAdapter(max_retries=retry)
        self.session.mount('http://', adapter)
        self.session.mount('https://', adapter)

    def get_stat(self):
        payload = {'format': 'json'}
        url = self.base_url + '/v1/stat/'

        try:
            r = self.session.get(url, params=payload, verify=self.ssl_verify)
            result = r.json()
        except Exception as e:
            logging.exception(e)
            return {}
        return result

    def get_targets(self, filter_values=()):
        payload = {'format': 'json'}

        if filter_values:
            payload[filter_values[0]] = filter_values[1]

        url = self.base_url + '/v1.1/targets/'
        try:
            r = self.session.get(url, params=payload, verify=self.ssl_verify)
            json_data = r.json()
            result = json_data['targets']
        except Exception as e:
            logging.exception(e)
            return []
        return result

    def get_targets_by_startrek(self, st, only_one=False):
        result = self.get_targets(filter_values=('tracker_startrek', st))
        if only_one and result:
            return result[0]
        return result

    def init_scan(self, url, profile='Yandex', **kwargs):
        payload = {'target_uri': url, 'profile': profile}

        if 'st_queue' in kwargs:
            payload['st_queue'] = kwargs['st_queue']

        if 'user_agent' in kwargs:
            payload['user_agent'] = kwargs['user_agent']

        if 'auth_profile' in kwargs:
            payload['auth_profile'] = kwargs['auth_profile']

        if 'qs_params' in kwargs:
            payload['qs_params'] = kwargs['qs_params']

        if 'rps' in kwargs:
            payload['rps'] = kwargs['rps']

        if 'st_ticket' in kwargs:
            payload['st_ticket'] = kwargs['st_ticket']

        if 'abc_id' in kwargs:
            payload['abc_id'] = kwargs['abc_id']

        if 'target' in kwargs:
            payload['target'] = kwargs['target']

        if 'users' in kwargs:
            payload['users'] = kwargs['users']

        if 'request_samples' in kwargs:
            payload['request_samples'] = kwargs['request_samples']

        if 'severity' in kwargs:
            payload['severity'] = kwargs['severity']

        if 'request_samples_resource_type' in kwargs:
            payload['request_samples_resource_type'] = kwargs['request_samples_resource_type']

        if 'request_samples_resource' in kwargs:
            payload['request_samples_resource'] = kwargs['request_samples_resource']

        if 'ignore_time_limit' in kwargs:
            payload['ignore_time_limit'] = kwargs['ignore_time_limit']

        if 'no_auto_tickets' in kwargs:
            payload['no_auto_tickets'] = kwargs['no_auto_tickets']

        if 'request_samples_aggregate_uid' in kwargs:
            payload['request_samples_aggregate_uid'] = kwargs['request_samples_aggregate_uid']

        url = self.base_url + '/v1.1/scan/'
        r = self.session.post(url, data=payload, verify=self.ssl_verify)
        if r.status_code == 200:
            resp = r.json()
            scan_ids = resp.get('scan_id', [])
            if scan_ids:
                scan_id = scan_ids.pop()
                self.scan_id = scan_id
                logging.info('New Molly scan created, id: {}'.format(self.scan_id))
                return self.scan_id
        logging.info('Molly scan creation error, HTTP status: {}, details: {}'.format(r.status_code, r.text))
        self.scan_id = None
        return False

    def fetch_scan_progress(self, scan_id=''):
        if not scan_id:
            scan_id = self.scan_id

        url = self.base_url + '/v1.1/scan/{scan_id}'
        r = self.session.get(url.format(scan_id=urllib.urlencode({'': scan_id})[1:]), verify=self.ssl_verify)
        logging.info('Molly fetch scan status_code: {}'.format(r.status_code))

        if r.status_code != 200:
            logging.error('Molly scan status fetch error, HTTP status: {}, details: {}'.format(r.status_code, r.text))
            return {}
        return r.json()
