# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import sandboxapi

from sandbox.projects.common.nanny import nanny

import logging


class Params(object):
    class ReleaseTo(parameters.SandboxStringParameter):
        name = 'release_to'
        choices = [('do not release', '')] + [(x, x) for x in sandboxapi.RELEASE_STATUSES]
        description = 'Release resource to'
        default_value = ''

    class ReleaseTtl(parameters.SandboxStringParameter):
        name = 'release_ttl'
        description = 'Released resources TTL'
        required = False
        default_value = 'inf'

    params = [
        ReleaseTo,
        ReleaseTtl,
    ]


class NewsAutoreleasableTask(nanny.ReleaseToNannyTask, task.SandboxTask):
    '''
    '''

    type = 'NEWS_AUTORELEASABLE_TASK'

    input_parameters = Params.params

    do_release = 'do_release'

    def do_execute(self):
        raise NotImplementedError('You should implement do_execute() by yourself!')

    def on_release(self, *args, **kwargs):
        nanny.ReleaseToNannyTask.on_release(self, *args, **kwargs)

    def on_execute(self):
        if self.ctx.get(self.do_release):
            with self.memoize_stage.wait_parent:
                self.wait_tasks(self.parent_id, (self.Status.Group.FINISH + self.Status.Group.BREAK), wait_all=True)

            self.create_release(self.parent_id, status=self.ctx[Params.ReleaseTo.name], subject='[{}] {}'.format(self.type, (self.descr if self.descr else 'Automatic release')))

        elif self.do_execute():  # <<<===--- EXECUTION IS HERE
            if self.ctx[Params.ReleaseTo.name]:
                child_params = dict(self.ctx)
                child_params.update({self.do_release: True})
                self.create_subtask(self.type, 'Release ' + self.descr, child_params, priority=self.priority, execution_space=self.execution_space, inherit_notifications=True)
            else:
                logging.warning("Skip release due to missing 'release to' target")

    def mark_released_resources(self, status, ttl='inf'):
        custom_ttl = self.ctx.get(Params.ReleaseTtl.name, None)
        if custom_ttl is not None:
            try:
                custom_ttl = int(custom_ttl)
            except ValueError:
                pass
            ttl = custom_ttl
        return task.SandboxTask.mark_released_resources(self, status, ttl)

__Task__ = NewsAutoreleasableTask
