# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common import apihelpers

from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.paths import make_folder

import os


class NewsUnpackGeodataTZData(NewsAutoreleasableTask):
    """"""

    type = "NEWS_UNPACK_GEODATA_TZ_DATA"

    def do_execute(self):
        data_path = self.sync_resource(apihelpers.get_last_resource_with_attrs(
            'GEODATATZDATA_STABLE',
            {'released': 'stable'},
            all_attrs=True
        ))

        workcopy_dir = self.abs_path('tzdata')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir)

        run_process('tar zxf {}'.format(data_path), shell=True)

        resource = self.create_resource(
            description=self.descr,
            resource_path='tzdata',
            resource_type=resource_types.NEWS_UNPACKED_GEODATA_TZ_DATA,
            arch=self.arch,
            attributes={}
        )

        self.mark_resource_ready(resource.id)

        return True


__Task__ = NewsUnpackGeodataTZData
