# -*- coding: utf-8 -*-

import logging
import shutil

from sandbox import sdk2
from sandbox.common.errors import TaskError
from sandbox.sdk2.environments import PipEnvironment

from tester import Tester


class ContinuousNoapacheupperTest(sdk2.Task):
    """
         Непрерывное тестирование с низким RPS(1-10)
    """

    class Parameters(sdk2.Parameters):
        max_restarts = 10
        kill_timeout = 360000

        with sdk2.parameters.Group("Arcadia parameters") as arcadia_block:
            test_data_url = sdk2.parameters.ArcadiaUrl('test data url with config, boxes and functions', default_value="arcadia:/arc/trunk/arcadia/search/tools/serp_tester")

        with sdk2.parameters.Group("Requester parameters") as request_block:
            run_boxes_count = sdk2.parameters.Integer('Сколько раз прогнать корзины (= 0 -  отрезать по времени)', default=0,
                                                       default_value=0)
            monitoring_time = sdk2.parameters.Float('Сколько времени мониторить в часах (вещественное число)', default=1,
                                                        default_value=1.0)

            max_resend_count = sdk2.parameters.Integer('max resend on bad answers (retry limit)', default=5, default_value=5)
            host = sdk2.parameters.String('no specific report_url (if no exist in config for box)',
                                                description='host (default: https://hamster.yandex.ru)',
                                                default='https://hamster.yandex.ru',
                                                default_value='https://hamster.yandex.ru')

        yt_res_dir = sdk2.parameters.String("Директория  логов", default_value="//home/geosearch/gav1995/ContinuousNoapacheupperTest/log")
        yt_res_ttl = sdk2.parameters.Integer("ttl логов", default_value=1)
        yt_request_table = sdk2.parameters.String("таблица запросов", default_value="//home/geosearch/gav1995/ContinuousNoapacheupperTest/requests_for_soy")

        with sdk2.parameters.Group("solomon parameters"):
            solomon_project = sdk2.parameters.String('solomon project', default="serp_tester", default_value="serp_tester")
            solomon_cluster = sdk2.parameters.String('solomon cluster', default="sandbox", default_value="sandbox")
            solomon_service_monitoring = sdk2.parameters.String('solomon production service', default="monitoring", default_value="monitoring")
            solomon_service_testing = sdk2.parameters.String('solomon production service', default="testing", default_value="testing")

        ssh_key = sdk2.parameters.String('ssh-key in Vault', default='gav_ssh', default_value='gav_ssh')
        ssh_owner = sdk2.parameters.String('ssh-owner in Vault', default='gav1995', default_value='gav1995')

    class Requirements(sdk2.Task.Requirements):
        environments = [
            PipEnvironment('yandex-yt')
            ]

    def on_execute(self):
        test_path = sdk2.svn.Arcadia.checkout(self.Parameters.test_data_url, "test_data")
        logging.log(0, str(self.Parameters.test_data_url) + " checkout successful to" + test_path)
        tester = Tester(self, self.Parameters, test_path)
        while tester.need_run_config():
            sdk2.svn.Arcadia.update(test_path, depth='infinity')
            try:
                tester.run_config()
            except TaskError as TE:
                logging.error("-------requester error!---------" + str(TE))
        shutil.rmtree(test_path)
