# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.task as ctt
import sandbox.common.types.client as ctc

import differ


class DiffWizardsResource(sdk2.Resource):
    """dict file - diff two WizardsResource"""


class DiffNoapacheupper(sdk2.Task):
    """
        **Описание**
         Тест обстрела двух noapache-й через репорт (пользовательскими запросами)
         Построение diff по ответам noapache-й
    """

    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.LINUX_PRECISE

    class Parameters(sdk2.Parameters):
        description = "Differ Noapacheupper"
        max_restarts = 10
        kill_timeout = 3600

        use_arcadia = sdk2.parameters.Bool('Build from arcadia', default_value=True)

        with use_arcadia.value[True]:
            with sdk2.parameters.Group("first version") as first_block:
                arcadia_url_first = sdk2.parameters.ArcadiaUrl('arcadia url')
                rearrange_data_url_first = sdk2.parameters.String('Svn url for branch with rearrange data',
                                                                  default_value='arcadia:/arc/trunk/')
                noapache_config_url_first = sdk2.parameters.String('Svn url for branch with current config options',
                                                                   default_value='arcadia:/arc/trunk/')
                wizards_resource_first = sdk2.parameters.Resource('resource ready wizards')  # ,
                                                                  # resource_type=sdk2.Resource["WIZARDS_RESOURCE"])
                additional_cgi_params_first = sdk2.parameters.String('Additional cgi params first', default_value='')

        with use_arcadia.value[True]:
            with sdk2.parameters.Group("second version") as second_block:
                arcadia_url_second = sdk2.parameters.ArcadiaUrl('arcadia url')
                rearrange_data_url_second = sdk2.parameters.String('Svn url for branch with rearrange data',
                                                                   default_value='arcadia:/arc/trunk/')
                noapache_config_url_second = sdk2.parameters.String('Svn url for branch with current config options',
                                                                    default_value='arcadia:/arc/trunk/')
                wizards_resource_second = sdk2.parameters.Resource('resource ready wizards')  # ,
                                                                   # resource_type=sdk2.Resource["WIZARDS_RESOURCE"])
                additional_cgi_params_second = sdk2.parameters.String('Additional cgi params second', default_value='')

        with sdk2.parameters.Group("Noapacheupper parameters") as mode_block:
            apphost_mode = sdk2.parameters.Bool('Use apphost mode', default_value=True)
            start_timeout = sdk2.parameters.Integer('Start timeout (sec)', default_value=600)
            shutdown_timeout = sdk2.parameters.Integer('Shutdown timeout (sec)', default_value=60)
            server_input_deadline = sdk2.parameters.String(
                'DDoS protection (read input data timeout, empty_string == not change)', default_value='')

        with sdk2.parameters.Group("Requester parameters") as request_block:
            limit_requests = sdk2.parameters.Integer('Limit number of used requests (0 = all)', default_value=0)
            use_workers = sdk2.parameters.Integer('Use workers (processes) for sending requests', default_value=5)
            report_url = sdk2.parameters.String('report_url',
                                                description='Report url (default: https://hamster.yandex.ru/search?)',
                                                default_value='https://hamster.yandex.ru/search?', multiline=True)
            users_queries = sdk2.parameters.LastReleasedResource(
                'Users queries')  # , resource_type=sdk2.Resource["USERS_QUERIES"])
            method = sdk2.parameters.String('Method for grabber', default_value='xpath_get')
            additional_method_arguments = sdk2.parameters.String('Additional method params', default_value='')

    def init_search_component(self, component):
        pass

    def call_tests_noapacheupper(self):
        task_type = sdk2.Task["TEST_NOAPACHEUPPER_2"]
        p = self.Parameters
        subtasks = {}

        if not self.Parameters.wizards_resource_first:
            first = task_type(
                self, description="Created from SDK2-task", use_arcadia=p.use_arcadia,
                arcadia_url=p.arcadia_url_first, rearrange_data_url=p.rearrange_data_url_first,
                noapache_config_url=p.noapache_config_url_first, apphost_mode=p.apphost_mode,
                start_timeout=p.start_timeout, shutdown_timeout=p.shutdown_timeout,
                server_input_deadline=p.server_input_deadline, limit_requests=p.limit_requests,
                use_workers=p.use_workers, report_url=p.report_url,
                users_queries=p.users_queries, additional_cgi_params=p.additional_cgi_params_first,
                method=p.method, additional_method_arguments=p.additional_method_arguments
            ).enqueue()
            subtasks['first'] = first.id

        if not self.Parameters.wizards_resource_second:
            second = task_type(
                self, description="Created from SDK2-task", use_arcadia=p.use_arcadia,
                arcadia_url=p.arcadia_url_second, rearrange_data_url=p.rearrange_data_url_second,
                noapache_config_url=p.noapache_config_url_second, apphost_mode=p.apphost_mode,
                start_timeout=p.start_timeout, shutdown_timeout=p.shutdown_timeout,
                server_input_deadline=p.server_input_deadline, limit_requests=p.limit_requests,
                use_workers=p.use_workers, report_url=p.report_url,
                users_queries=p.users_queries, additional_cgi_params=p.additional_cgi_params_second,
                method=p.method, additional_method_arguments=p.additional_method_arguments
            ).enqueue()
            subtasks['second'] = second.id

        # Save ids to context to process them after waking up
        self.Context.subtasks_ids = subtasks

        raise sdk2.WaitTask(list(subtasks.values()), ctt.Status.Group.FINISH, wait_all=True)

    def get_results_from_child_tasks_or_params(self):
        child_tasks = self.Context.subtasks_ids
        res1 = self.Parameters.wizards_resource_first if self.Parameters.wizards_resource_first else \
            sdk2.Resource["WIZARDS_RESOURCE"].find(task_id=child_tasks["first"]).first()
        res2 = self.Parameters.wizards_resource_second if self.Parameters.wizards_resource_second else \
            sdk2.Resource["WIZARDS_RESOURCE"].find(task_id=child_tasks["second"]).first()
        return res1, res2

    def on_execute(self):
        with self.memoize_stage.create_children:
            self.call_tests_noapacheupper()

        resource1, resource2 = self.get_results_from_child_tasks_or_params()
        wizards1 = differ.read_dict_from_file(str(sdk2.ResourceData(resource1).path))
        wizards2 = differ.read_dict_from_file(str(sdk2.ResourceData(resource2).path))
        wizards_short_1 = differ.get_without_noapache_cgi_parameters(wizards1)
        wizards_short_2 = differ.get_without_noapache_cgi_parameters(wizards2)
        diff_wizards = differ.get_diff_between_dicts(wizards_short_1, wizards_short_2)

        resource = DiffWizardsResource(self, "diff of two tests noapacheuppers", "resource_directory", ttl=30)
        resource_data = sdk2.ResourceData(resource)
        differ.print_to_file(diff_wizards, str(resource_data.path))
        resource_data.ready()
