# -*- coding: utf-8 -*-

import logging
import subprocess


from sandbox import sdk2
from sandbox.sandboxsdk.channel import channel


class RealtyTest(sdk2.Task):
    """
        Тестирование показов кнопки Недвижимости
    """

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Параметры аркадии"):
            arc_grabber = sdk2.parameters.ArcadiaUrl('grabber url', default_value="arcadia:/arc/trunk/arcadia/search/geo/tools/serp_grabber/")
            arc_pool = sdk2.parameters.ArcadiaUrl('url корзины', default_value="arcadia:/arc/trunk/arcadia/search/tools/serp_tester/boxes/")
        email_to = sdk2.parameters.Staff('адресат отчёта', default="gav1995", default_value="gav1995")
        command = sdk2.parameters.String(
            'команда',
            default_value="python3 {path_grabber}/grab.py --method=get_phone --flags=&json_dump=searchdata.docs_right")

    def on_execute(self):
        path_grabber = sdk2.svn.Arcadia.checkout(self.Parameters.arc_grabber, "grabber", depth='infinity')
        path_pool = sdk2.svn.Arcadia.checkout(self.Parameters.arc_pool, "pool")
        logging.info("checkout successful {} and {}".format(path_grabber, path_pool))
        logging.info("We will test pool:")
        pool = ""
        with open(path_pool+'/realty.csv', 'r') as file:
            for row in file:
                logging.info(row)
                pool += row
        bashCommand = self.Parameters.command.format(path_pool=path_pool, path_grabber=path_grabber)
        logging.info("bashCommand = {}".format(bashCommand))
        process = subprocess.Popen(bashCommand.split(), stdout=subprocess.PIPE, stderr=subprocess.PIPE, stdin=subprocess.PIPE)
        output, error = process.communicate(pool)
        process = subprocess.Popen(['grep', 'null'], stdout=subprocess.PIPE, stderr=subprocess.PIPE, stdin=subprocess.PIPE)
        output, error2 = process.communicate(output)
        output = output.split('\n')
        output = '\n'.join(['\t'.join(row.split('\t')[:2]) for row in output])
        msg = str(output)
        logging.info("error = {}".format(error))
        logging.info("to {} send message \"{}\"".format(self.Parameters.email_to, msg))
        channel.sandbox.send_email(mail_to=self.Parameters.email_to.split(', '), mail_cc='', mail_subject='RealtyTest report', mail_body=msg)
