from sandbox import sdk2

import sandbox.projects.resource_types.releasers as resource_releasers


class MapsSearchConfigCollections(sdk2.Resource):
    """
        Config for org collections basesearch
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class OrgCollectionsBasesearchExecutable(sdk2.Resource):
    """
        Basesearch executable for org collections
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/base/geobasesearch/geobasesearch'


class OrgCollectionsIndexerExecutable(sdk2.Resource):
    """
        Indexer for org collections search
    """
    executable = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class OrgCollectionsIndex(sdk2.Resource):
    """
        Index for org collections search
    """
    releasable = True
    releasers = resource_releasers.geosearch_releasers
