import logging
import os
from sandbox import sandboxsdk

import sandbox.projects.resource_types.releasers as resource_releasers
from sandbox.projects import resource_types

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import ResourceSelector, SandboxStringParameter

from sandbox.sandboxsdk.process import run_process


class BUILD_SOCIAL_PROFILE_2_GEOIDS_EXECUTABLE(resource_types.AbstractResource):
    """
        YT-tool for building map profile -> geoids where this profile is presented
    """
    executable = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/social_links/build_profile2geoids'


class Executable(ResourceSelector):
    name = 'executable'
    description = 'Profile2Geoids executable'
    resource_type = BUILD_SOCIAL_PROFILE_2_GEOIDS_EXECUTABLE


class YTSourceTable(SandboxStringParameter):
    name = 'source'
    description = 'Path to YT source table'
    default_value = '//home/sprav/altay/prod/snapshot/company'
    required = True


class YTDstTable(SandboxStringParameter):
    name = 'dst'
    description = 'Path to YT destination table'
    default_value = '//home/geosearch/social_networks/profile_url2geoids'
    required = True


class Executor(SandboxTask):
    '''Profile2Geoids builder.'''

    type = 'BUILD_SOCIAL_PROFILE_2_GEOIDS'

    input_parameters = (
        Executable,
        YTSourceTable,
        YTDstTable,
    )

    environment = [sandboxsdk.environments.PipEnvironment('yandex-yt')]

    def on_execute(self):
        executable = self.sync_resource(self.ctx.get(Executable.name))

        os.environ['MR_RUNTIME'] = 'YT'
        os.environ['YT_TOKEN'] = self.get_vault_data(self.owner, 'yt-token')
        os.environ['YT_PROXY'] = 'hahn.yt.yandex.net'
        os.environ['YT_LOG_LEVEL'] = 'INFO'

        extract_cmd = [executable,
                       '--src', self.ctx.get(YTSourceTable.name),
                       '--dst', self.ctx.get(YTDstTable.name),
                       ]

        logging.info('Run command: {}'.format(' '.join(extract_cmd)))
        run_process(extract_cmd)
        logging.info('Done')


__Task__ = Executor
