# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.OrgSocialLinks.org_events_updater import Task as OrgEventsUpdaterTask

from sandbox.projects.common.geosearch.indexing import generate_base_update_task

BaseUpdate = generate_base_update_task(
    build_task=OrgEventsUpdaterTask,
    index_type_for_timestamp=resource_types.TASK_LOGS,
    release_subject="Update org events",
    force_rebuild=True
)


class UpdateOrgEventsUpdater(BaseUpdate):
    """
        Gets fresh releases as input and launhes ORG_EVENTS_UPDATER
    """
    type = 'UPDATE_ORG_EVENTS_UPDATER'


__Task__ = UpdateOrgEventsUpdater
