# -*- c//oding: utf-8 -*
import codecs
import json
import logging
from os import listdir, path, system
import re
import shutil
from time import sleep
import urllib
import urllib2

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.channel import channel
from sandbox.projects.common import apihelpers
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia


# Test Parameters
# arcadia:/arc/trunk
class Revision(SandboxStringParameter):
    name = 'revision'
    description = 'Revision'
    default_value = 'HEAD'


# logging

def print_good_info(self, msg):
    self.set_info('<font color="green">' + msg + '</font>', do_escape=False)


def print_err(self, msg):
    self.set_info('<font color="red">' + msg + '</font>', do_escape=False)


# yassert
def yassert(condition, msg='', font='red'):
    if not condition:
        raise SandboxSubprocessError('ERROR! <font color="' + font + '">' + str(msg) + '</font>')


# web
def has_page(page_url, self=None):
    con = urllib.urlopen(page_url)
    con_code = con.getcode()
    if con_code == 200:
        return True
    elif con_code == 404:
        return False
    if self:
        self.set_info('in has_page: ' + page_url + ', con_code = ' + str(con_code))
    return False


# files

def append_text(filename, text, do_chmod=False):
    if not path.exists(filename):
        create_file_with_content(filename, text)
        return
    if do_chmod:
        run_process(['chmod', 'a+rwx', filename], check=False)
    f = open(filename, 'a')
    f.write(text)
    f.close()


def append_text_to_head(filename, appended_text):
    text = read_text(filename)
    text = appended_text + text
    write_text(filename, text)


def download_text(url, filename):
    try:
        downloaded_text = urllib2.urlopen(url, timeout=1000000).read()
    except:
        return False
    write_text(filename, downloaded_text)
    return True


def download_and_get_text(url):
    logging.info('download_text(' + url + ')')
    return urllib2.urlopen(url).read()


def download_archive_and_extract(url, local_path):
    run_process(['wget', '-O', local_path + '.tar.gz', url])
    tmp_folder = 'tmp'
    make_folder(tmp_folder)
    run_process(['tar', 'xvzf', local_path + '.tar.gz', '-C', tmp_folder])
    run_process(['mv', tmp_folder + '/' + listdir(tmp_folder)[-1], local_path])


def create_file_with_content(filename, text):
    folder = '.'
    if '/' in filename:
        folder = '/'.join(filename.split('/')[:-1])
        if not path.exists(folder):
            system('mkdir -p ' + folder)
        assert(path.exists(folder))
    #os.system('printf \'' + text + '\' > "' + path + '" 2>&1')
    try:
        open(filename, 'w').write(text)
    except:
        pass
    if not path.exists(filename):
        try:
            system('chmod -R a+rw "' + folder + '"')
            open(filename, 'w').write(text)
        except:
            pass
    assert(path.exists(filename))


def create_file(filename):
    create_file_with_content(filename, '')


def read_text(filename):
    return open(filename, 'r').read()


def write_text(filename, text):
    open(filename, 'w').write(text)


def replace(filename, str1, str2):
    text = read_text(filename)
    text = text.replace(str1, str2)
    write_text(filename, text)


def recursive_replace(folder, file_mask, old_str, new_str, cmd_prefix=None):
    cmd = ''
    if cmd_prefix:
        cmd = ' '.join(cmd_prefix) + ' '
    cmd += "for f in " + folder + "/" + file_mask + "; " \
           "do sed 's/" + old_str.replace('/', '\/') + "/" + new_str.replace('/', '\/') + "/g' $f > ftmp; mv ftmp $f; done"
    system(cmd)


def recursive_replace_on_host(host, folder, file_mask, old_str, new_str):
    recursive_replace(folder, file_mask, old_str, new_str, cmd_prefix=['ssh', host])


def replace_on_host(host, file_path, old_str, new_str):
    cmd = ['sed', '-ie', '"s/' + old_str.replace('/', '\/') + '/' + new_str.replace('/', '\/') + '/g"', file_path]
    run_in_host(host, cmd)


def get_beauty_json(input_json_file, output_json_file):
    # need to use codecs for output to avoid error in json.dump
    output_file = codecs.open(output_json_file, "w", encoding="utf-8")

    # read the file and decode possible UTF-8 signature at the beginning which can be the case in some files.
    input_text = read_text(input_json_file)
    if input_text != '':
        j = json.loads(input_text.decode("utf-8-sig"))
        # then output it, indenting, sorting keys and ensuring representation as it was originally
        json.dump(j, output_file, indent=4, sort_keys=True, ensure_ascii=False)
    else:
        output_file.write('')


# diff

def calculate_diff(log_str, entity, old_ans_path, new_ans_path, diff_path, fails_diff_path, is_json=False):
    if not (path.exists(new_ans_path) and path.exists(old_ans_path)):
        if not path.exists(new_ans_path):
            log_str += '<br />WARNING! There isn\'t new_ans file: ' + new_ans_path + '<br /><br />'
        else:
            log_str += '<xmp style="margin: 0px;">new_ans=' + read_text(new_ans_path) + '</xmp>'
        if not path.exists(old_ans_path):
            log_str += 'WARNING! There isn\'t old_ans file: ' + old_ans_path + '<br /><br />'
        else:
            log_str += '<xmp style="margin: 0px;">old_answer=' + read_text(old_ans_path) + '</xmp>'
        append_text(diff_path, log_str)
        append_text(fails_diff_path, log_str)
        return True

    log_str += '<xmp style="margin: 0px;">new_ans=' + read_text(new_ans_path) + '</xmp>'

    new_ans_beauty_json_path = 'tmp/' + entity + '_new_ans.txt'
    old_ans_beauty_json_path = 'tmp/' + entity + '_old_ans.txt'
    if is_json:
        get_beauty_json(old_ans_path, old_ans_beauty_json_path)
        get_beauty_json(new_ans_path, new_ans_beauty_json_path)
    else:
        shutil.copyfile(old_ans_path, old_ans_beauty_json_path)
        shutil.copyfile(new_ans_path, new_ans_beauty_json_path)

    tmp_diff = entity + '_test.tmp'
    has_diffs = has_diff(old_ans_beauty_json_path, new_ans_beauty_json_path, tmp_diff)
    diff_str = read_text(tmp_diff)

    log_str += '<xmp style="margin: 0px;">old_ans=' + read_text(old_ans_path) \
               + ('FAIL' if has_diffs else 'SUCCESS') + '\n\n' + diff_str + '</xmp>'
    append_text(diff_path, log_str)

    if has_diffs:
        append_text(fails_diff_path, log_str)
    return has_diffs


def has_diff(f1, f2, diff_path):
    if not path.exists(f1):
        return True
    if not path.exists(f2):
        return True
    system('diff ' + f1 + ' ' + f2 + ' > ' + diff_path + ' 2>&1')
    if not path.exists(diff_path):
        return False
    if read_text(diff_path) == '':
        return False
    return True


def get_md5_hash(filename):
    system("md5sum '" + filename + "' | awk '{print $1}' > md5_hash")
    md5_hash = open('md5_hash').read()[:-1]
    run_process(['rm', '-rf', 'md5_hash'])
    return md5_hash


# resources

def find_last_resource(resource_type, current_revision, branch):
    resources = apihelpers.get_resources_with_attribute(resource_type, attribute_name='branch', attribute_value=branch)
    most_last_resource = None
    most_last_revision = -1
    for resource in resources:
        if not('revision' in resource.attributes):
            continue
        r = int(resource.attributes['revision'])
        if most_last_revision < r < current_revision:
            most_last_revision = r
            most_last_resource = resource
    return most_last_resource


def read_text_from_url(url):
    download_text(url, 'tmp_file')
    if read_text('tmp_file') == '':
        logging.info('Sleep in read_text_from_url, url = ' + url)
        sleep(5*60)
        download_text(url, 'tmp_file')
    return read_text('tmp_file')


def run_in_host(host, cmd, check=True):
    run_process(['ssh', host] + cmd, log_prefix='ssh_' + cmd[0], wait=True, check=check)


def run_in_host_with_out_to_file(host, cmd, out_path):
    cmd_str = 'ssh ' + host + ' ' + ' '.join(cmd) + ' > ' + out_path + ' 2>&1'
    logging.info('execute: ' + cmd_str)
    system(cmd_str)


def download_text_used_host(host, url, filename):
    run_in_host_with_out_to_file(host, ['wget', '--no-check-certificate', '-q', '-O', '-', url], filename)


def contain_text_in_host(host, file_path, substr):
    """
    Vozvrashaet True, esli fajl file_path na mashine host soderjit stroku substr (regulyarka v perlovom formate)
    """
    cmd = ['cat', file_path]
    tmp_file_path = 'file_tmp'
    run_in_host_with_out_to_file(host, cmd, tmp_file_path)
    logging.info('contain_text_in_host. ' + read_text(tmp_file_path))
    n_consiliences = len(re.compile(substr).findall(read_text(tmp_file_path)))
    logging.info('n_consiliences=' + str(n_consiliences))
    if n_consiliences == 0:
        return False
    return True


def format_for_curl(s):
    return s.replace('%', '%25')\
        .replace('\n', '%0A')\
        .replace(' ', '%20')\
        .replace(',', '%2C')\
        .replace(':', '%3A')\
        .replace('=', '%3D')\
        .replace('@', '%40')\
        .replace('(', '%28')\
        .replace(')', '%29')


def get_url_after_redirect(start_url):
    req = urllib2.Request(start_url)
    res = urllib2.urlopen(req)
    final_url = res.geturl()
    return final_url


def log_info_to_str(log_line, separator):
    if not isinstance(log_line, tuple):
        str_log = log_line + separator
        return str_log
    field, value, error = log_line
    if error:
        str_log = '<font color="red">'
    else:
        str_log = '<font color="green">'
    str_log += field + '=' + str(value) + separator + '</font>'
    return str_log


def generate_log_str(log_info, separator='&emsp;'):
    str_log = '<b>'
    for log_line in log_info[:-1]:
        str_log += log_info_to_str(log_line, separator)
    return str_log + log_info_to_str(log_info[-1], '') + '</b>'


def map_of_map_to_html_table(m, align='center'):
    green = "#CCFFCC"
    red = "#FF6699"
    t = '<table>'
    t += '<tr>'
    t += '<td></td>'
    for r in m:
        t += '<td>' + str(r) + '</td>'
    t += '</tr>'
    if len(m.keys()) == 0:
        return t + '</table>'
    columns = set()
    for r in m:
        columns = columns | set(m[r])
    for c in columns:
        t += '<tr>'
        t += '<td>' + str(c) + '</td>'
        for r in m:
            if c in m[r]:
                b = m[r][c]
                color = red if b[2] else green
                onclick = '' if str(b[0]) == '' else 'onClick="location=\'' + str(b[0]) + '\'"'
                t += '<td valign="middle" align="' + align + '" ' + onclick + ' bgcolor="' + color + '">' + str(b[1]) + '</td>'
            else:
                t += '<td align="center" bgcolor="' + red + '">None</td>'
        t += '</tr>'
    t += '</table>'
    return t


def print_folder_tree(self, folder, recursive=False):
    tmp_filename = self.log_path('print_folder_tree_tmp.txt')
    recursive_param = '-R' if recursive else ''
    system('ls -al ' + recursive_param + ' -I __FUSE ' + folder + ' > ' + tmp_filename + ' 2>&1')
    logging.info('Print folder tree: ' + folder + '\n' + read_text(tmp_filename))


def check_that_server_running(self, port, cmd_prefix=None, timeout=180):
    for sec in range(timeout):
        sleep(1)
        cmd = (cmd_prefix if cmd_prefix else []) + ['wget', '-O', '-', 'localhost:' + str(port) + '/ping']
        p = run_process(cmd, log_prefix='test_running', wait=True, check=False)
        has_answer = (len(re.compile("200 Ok").findall(read_text(p.stdout_path)))) == 1
        if has_answer:
            self.set_info('iex run')
            return sec + 1
    print_folder_tree(self, self.abs_path(), recursive=True)
    self.yassert(False, 'Ne udalos zapustit IEX za ' + str(timeout) + ' sekund')
    return 0


def get_commit_date(revision):
    commit_date = str(Arcadia.info('arcadia:/arc/trunk@' + str(revision))['date'])
    #year = commit_date[:4]
    month = commit_date[5:7]
    day = commit_date[8:10]
    commit_time = commit_date[11:16]
    return day + '.' + month + ' ' + commit_time


def download_resource_to_host(host, resource_id, scp_params, dest_path_on_host):
    resource_path = channel.task.sync_resource(resource_id)
    logging.info('resource_path=' + resource_path)
    if not path.exists(resource_path):
        raise Exception("Resource path {} doesn't exist".format(resource_path))
    cmd = ['scp'] + scp_params + [resource_path, host + ':' + dest_path_on_host]
    run_process(cmd, log_prefix='scp_' + str(resource_id))
    new_resource_path = dest_path_on_host + '/' + resource_path.split('/')[-1]
    return new_resource_path


# arcadia_config

def comment_section_in_arcadia_conf(config_path, section_name):
    in_rca = False
    config_lines = read_text(config_path).splitlines()
    for line in config_lines:
        if '<' + section_name + '>' in line:
            in_rca = True
        if in_rca:
            if line.strip() != '':
                replace(config_path, line, '#' + line)
        if '</' + section_name + '>' in line:
            break


def get_port(config_filename):
    about_port = re.compile("Port : [\d]+").findall(read_text(config_filename))
    if len(about_port) == 0:
        about_port = re.compile("Port = [\d]+").findall(read_text(config_filename))
        if len(about_port) == 0:
            raise Exception("Unknown config\'s format: has no port.")
    return re.compile("[\d]+").findall(about_port[0])[0]
