import logging
from sandbox import sdk2
import os

from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr
from sandbox.common import errors


class PersonalPoisClickPoolExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ['MAPS-GEOQ-RELEASERS']


class PersonalPoisClickPoolTask(sdk2.Task):
    '''Task for calculate pool for personal pois service'''

    class Parameters(sdk2.Task.Parameters):

        resource_id = sdk2.parameters.LastReleasedResource(
            'Resource Id',
            resource_type=PersonalPoisClickPoolExecutable,
            state=(ctr.State.READY,),
            required=True,
        )

        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            yt_vault_token = sdk2.parameters.String('Your token name in vault', default='yt-token', required=True)

        with sdk2.parameters.Group('Binary parameters') as cmd:
            update_history = sdk2.parameters.Bool('Grep new history?')

            radius = sdk2.parameters.Integer('radius', default=10)

            date = sdk2.parameters.String('date (YYYY-mm-dd)')

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        with self.memoize_stage.run_phase:

            runner = self.Parameters.resource_id

            if runner is None:
                raise errors.TaskError('No executable founded')
            runner = sdk2.ResourceData(runner)

            logging.info('Start run')
            with sdk2.helpers.ProcessLog(self, logger='run binary') as pl:
                env = os.environ.copy()
                env['YT_TOKEN'] = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token)
                if self.Parameters.update_history:
                    run = [
                        str(runner.path),
                        '--radius', str(self.Parameters.radius),
                        'grep-history'
                    ]
                    ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
                    if ret:
                        raise errors.TaskError('grep-history is failed')

                run = [
                    str(runner.path),
                    '--radius', str(self.Parameters.radius),
                    'grep-maps-pois',
                    '--date', str(self.Parameters.date)
                ]
                ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
                if ret:
                    raise errors.TaskError('grep-maps-pois is failed')

                run = [
                    str(runner.path),
                    '--radius', str(self.Parameters.radius),
                    'grep-clicks',
                    '--date', str(self.Parameters.date)
                ]
                ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
                if ret:
                    raise errors.TaskError('grep-clicks is failed')

                run = [
                    str(runner.path),
                    '--radius', str(self.Parameters.radius),
                    'get-good-clicks',
                    '--date', str(self.Parameters.date)
                ]
                ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
                if ret:
                    raise errors.TaskError('get-good-clicks is failed')
