import logging
from sandbox import sdk2
import os

from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr
from sandbox.common import errors


class PersonalPoiFeaturesExecutable(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ['MAPS-GEOQ-RELEASERS']


class PersonalPoiFeatures(sdk2.Task):
    '''Calculate and return features'''

    class Parameters(sdk2.Task.Parameters):
        resource_id = sdk2.parameters.LastReleasedResource(
            'Resource Id',
            resource_type=PersonalPoiFeaturesExecutable,
            state=(ctr.State.READY,),
            required=True,
        )
        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            yt_vault_token = sdk2.parameters.String('Your token name in vault', default='yt-token', required=True)

        with sdk2.parameters.Group('Metrics run parameters') as grepper_parameters:
            first_day = sdk2.parameters.String(
                'First day of time interval',
                required=True
            )
            last_day = sdk2.parameters.String(
                'Last day of time interval(noninclusive)',
                required=True
            )
            input_folder = sdk2.parameters.String(
                'Folder in YT with grepped tables',
                required=False,
            )
            result_folder = sdk2.parameters.String(
                'Folder in YT for feature tables',
                required=False,
            )

    class Requirements(sdk2.Task.Requirements):
        pass

    def on_execute(self):

        if self.Parameters.resource_id is None:
            raise errors.TaskError('No executable founded')
        runner = sdk2.ResourceData(self.Parameters.resource_id)

        with self.memoize_stage.run_phase:
            logging.info('Start run')

            run = [
                str(runner.path),
                '--begin', self.Parameters.first_day,
                '--end', self.Parameters.last_day,
                '--max-operation-count', '1',
                '-a', '3', '-a', '7', '-a', '14', '-a', '30',
            ]
            if self.Parameters.input_folder:
                run += [
                    '--input-folder', self.Parameters.input_folder,
                ]
            if self.Parameters.result_folder:
                run += [
                    '--output-folder', self.Parameters.result_folder,
                ]

            with sdk2.helpers.ProcessLog(self, logger='run features') as pl:
                env = os.environ.copy()
                env['YT_TOKEN'] = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token)

                ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
                if ret:
                    raise errors.TaskError('Grep failed')
