import logging
from sandbox import sdk2
import os

from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr
from sandbox.common import errors
from sandbox.projects.resource_types import PERSONAL_POI_SQUEEZER_EXECUTABLE


class PersonalPoiSqueezeLogs(sdk2.Task):
    '''Squeeze user sessions to lighter format'''

    class Parameters(sdk2.Task.Parameters):

        resource_id = sdk2.parameters.LastReleasedResource(
            'Resource Id',
            resource_type=PERSONAL_POI_SQUEEZER_EXECUTABLE,
            state=(ctr.State.READY,),
            required=True,
        )
        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            yt_vault_token = sdk2.parameters.String('Your token name in vault', default='yt-token', required=True)
        with sdk2.parameters.Group('Squeezer run parameters') as grepper_parameters:
            common_folder = sdk2.parameters.String(
                'Folder in YT for grepped tables',
                default='//home/geosearch/zhshishkin/grepper/',
                required=True
            )
            jobs_number = sdk2.parameters.Integer(
                'Number of parallel jobs',
                default=1,
                required=False,
            )
            first_day = sdk2.parameters.String(
                'First day of time interval',
                default='2017-01-01',
                required=False
            )
            last_day = sdk2.parameters.String(
                'Last day of time interval',
                default='3000-01-01',
                required=False
            )

    class Requirements(sdk2.Task.Requirements):
        pass

    def on_execute(self):
        with self.memoize_stage.get_runner_stage:

            runner = self.Parameters.resource_id

            if runner is None:
                raise errors.TaskError('No executable founded')
            runner = sdk2.ResourceData(runner)

        with self.memoize_stage.run_phase:

            logging.info('Start run')
            with sdk2.helpers.ProcessLog(self, logger='run grep') as pl:
                env = os.environ.copy()
                env['YT_TOKEN'] = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token)
                run = [
                    str(runner.path),
                    '--begin', str(self.Parameters.first_day),
                    '--end', str(self.Parameters.last_day),
                    '--njobs', str(self.Parameters.jobs_number),
                    '--common-folder', str(self.Parameters.common_folder),
                ]
                ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
                if ret:
                    raise errors.TaskError('Grep failed')
