from sandbox.sandboxsdk.task import SandboxTask

from sandbox.sandboxsdk.parameters import ResourceSelector, SandboxIntegerParameter, SandboxStringParameter, SandboxBoolParameter
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.utils import get_or_default

from sandbox.projects import resource_types

import os
import datetime


class PreparatProcessor(ResourceSelector):
    name = 'preparat_processor'
    description = 'Preparat processor: '
    resource_type = resource_types.SIMILAR_ORGS_PROCESS_PREPARAT_EXECUTABLE


class DaysNum(SandboxIntegerParameter):
    name = 'days_num'
    description = 'Days num: '
    default_value = 7


class PreparatPath(SandboxStringParameter):
    name = 'preparat_path'
    description = 'Preparat path: '
    default_value = 'similar_orgs_userdata/preparat/'


class ForceRecalc(SandboxBoolParameter):
    description = 'Force process preparats'
    name = 'force_recalc'
    hidden = False
    default_value = False


class ProcessSimilarsPreparat(SandboxTask):
    """
        Preprocess similar orgs preparat (from sobols@)
    """
    type = 'PROCESS_SIMILARS_PREPARAT'

    input_parameters = (
        PreparatProcessor,
        DaysNum,
        PreparatPath,
        ForceRecalc,
    )

    def on_execute(self):

        yt_token = self.get_vault_data('GEOMETA-SEARCH', 'yt-token')
        os.environ['YT_TOKEN'] = yt_token
        os.environ['YT_PREFIX'] = '//home/geosearch/'
        os.environ['YT_LOG_LEVEL'] = 'INFO'

        calcer = self.sync_resource(self.ctx.get('preparat_processor'))
        preparat_path = get_or_default(self.ctx, PreparatPath)
        days_num = get_or_default(self.ctx, DaysNum)
        force_recalc = get_or_default(self.ctx, ForceRecalc)

        exec_params = [calcer]
        exec_params.extend(['-p', preparat_path])
        exec_params.extend([datetime.datetime.now().strftime('%Y%m%d'), str(days_num)])

        if force_recalc:
            exec_params.append('-f')

        run_process(exec_params)


__Task__ = ProcessSimilarsPreparat
