# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxStringParameter

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.svn import Arcadia


class TankerUrl(SandboxStringParameter):
    name = 'tanker_url'
    description = 'Url to tanker with translations'
    default_value = 'http://tanker-api.tools.yandex.net:3000/keysets/tjson/?project-id=pogoda&keyset-id=weather-conditions-new&status=approved'


class ArcadiaPath(SandboxStringParameter):
    name = 'arcadia'
    description = 'Path to arcadia'
    default_value = 'arcadia:/arc/trunk/arcadia'


class ProxyWizardWeatherTranslations(SandboxTask):
    type = 'PROXY_WIZARD_WEATHER_TRANSLATIONS'
    input_parameters = (ArcadiaPath, TankerUrl)

    def initCtx(self):
        self.ctx['kill_timeout'] = 10 * 60

    def arcadia_info(self):
        return None, "Translations for Weather Proxy Wizard", None

    def on_execute(self):
        script = self.abs_path('translations.pl')
        with open(script, 'w') as f:
            f.write(Arcadia.cat(self.ctx['arcadia'] + '/extsearch/wizards/weather/scripts/translations.pl'))

        cmd = '/usr/bin/env perl %s "%s"' % (script, self.ctx['tanker_url'])

        fn_translations = self.abs_path('translations.json')
        with open(fn_translations, 'w') as fd_out:
            process = run_process(cmd, wait=True, shell=True, stdout=fd_out)
            if not process or process.returncode:
                raise SandboxTaskFailureError('Process %s died' % cmd)

        self.create_resource('Weather translations json', fn_translations, 'PROXY_WIZARD_WEATHER_TRANSLATIONS')


__Task__ = ProxyWizardWeatherTranslations
