# -*- coding: utf-8 -*-

from sandbox.projects.PublishNewsArchive import PublishNewsArchive

from sandbox.sandboxsdk import task as st
from sandbox.sandboxsdk import parameters as sp
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class ReleaseShardmap(sp.SandboxBoolParameter):
    name = 'release'
    description = 'Release shardmap'
    default_value = False


class PublishNewsArchiveWrapper(st.SandboxTask):
    '''
    Download, register and publish all archive shards
    '''

    type = 'PUBLISH_NEWS_ARCHIVE_WRAPPER'

    cores = 1
    required_ram = 1024  # 1GB

    input_parameters = [ReleaseShardmap] + PublishNewsArchive.input_parameters

    def on_execute(self):
        if 'subtask' not in self.ctx:
            task = self.create_subtask('PUBLISH_NEWS_ARCHIVE',
                                       "Prepare new shards",
                                       self.ctx,
                                       inherit_notifications=True)
            self.ctx['subtask'] = task.id
            self.wait_tasks(task,
                            self.Status.Group.SUCCEED + self.Status.Group.SCHEDULER_FAILURE,
                            wait_all=True,
                            state="Waiting for shards preparing")
        else:
            # check subtasks status
            task_id = self.ctx['subtask']
            task = channel.sandbox.get_task(task_id)
            if not task.is_finished():
                raise SandboxTaskFailureError("Subtask %s failed" % task_id)

            if self.ctx.get(ReleaseShardmap.name):
                release = self.create_release(task_id,
                                              status='stable',
                                              subject='Arcnews shards',
                                              comments='base from %s' % task.ctx['timestamp'],
                                              changelog=None,
                                              addresses_to='news-releases@yandex-team.ru')
                if not release:
                    raise SandboxTaskFailureError('Cannot release task')


__Task__ = PublishNewsArchiveWrapper
