# coding: utf-8

from sandbox.projects.CollectAntirobotData import CollectAntirobotData
import logging

RELEASE_SUBTASK_ID = 'release_subtask_id'
RELEASE_TRIES_COUNT = 10


class ReleaseAntirobotData(CollectAntirobotData):
    """
        Релизим АнтиРоботные данные
    """

    type = 'RELEASE_ANTIROBOT_DATA'

    def on_execute(self):
        if not self.ctx.get(RELEASE_SUBTASK_ID):
            # first run ...
            self.current_action('Running real action in subtask')
            subtask = self.create_subtask('COLLECT_ANTIROBOT_DATA', 'subtask of %s(id=%d)' % (self.type, self.id))
            self.ctx[RELEASE_SUBTASK_ID] = subtask.id

            self.current_action('Waiting of subtask finish')
            self.wait_task_completed(subtask.id)
        else:
            # ... continuing after WAIT_CHILD
            self.current_action('Releasing subtask')

            for i in range(RELEASE_TRIES_COUNT):
                success = self.create_release(task_id=self.ctx[RELEASE_SUBTASK_ID], subject=self.title())
                if success:
                    break
                else:
                    logging.warning("Failed attempt to release a task")

            self.current_action('Done!')


__Task__ = ReleaseAntirobotData
