# -*- coding: utf-8 -*-

# common sandbox stuff
import os

from sandbox.sandboxsdk.process import run_process

# auxiliarily gencfg stuff
from sandbox.projects.common.gencfg import utils as config_generator_utils
from sandbox.projects.common.gencfg.task import IGencfgReleaseTask
import sandbox.common.types.client as client


class ReleaseConfigGenerator(IGencfgReleaseTask):
    type = 'RELEASE_CONFIG_GENERATOR'

    client_tags = client.Tag.CUSTOM_GENCFG_BUILD

    input_parameters = []

    @property
    def footer(self):
        return '<h2>{}</h2>'.format(self.ctx.get('result')) if self.is_finished() else ''

    def on_execute(self):
        # check if we called wait_tasks
        if self.ctx.get('releasing', False):
            return

        self.check_running_tasks()

        config_generator_utils.clone_gencfg_all(self.get_src_path(), 'full')

        run_process(["bash", "./install.sh", "tests"], work_dir=self.get_src_path(), log_prefix="install")

        if not self.need_new_tag(self.get_src_path(), os.path.join(self.get_src_path(), 'db')):
            self.set_info('Nothing to build')
            return

        subargs = self.generate_create_tag_bash_command("configs")
        custom_env = os.environ.copy()
        custom_env['GENCFG_DEFAULT_OAUTH'] = self.get_vault_data('GENCFG', 'gencfg_default_oauth')
        p = run_process(subargs, environment=custom_env, log_prefix='create_new_tag')

        self.release_built_tag(p.stdout_path)

        run_process(['./utils/standalone/update_tags_commits_ranges_mongo.py', 'last', 'None'], work_dir=self.get_src_path(), log_prefix='update_tags_commits_ranges_mongo')


__Task__ = ReleaseConfigGenerator
