# -*- coding: utf-8 -*-

import os

from sandbox.sandboxsdk.process import run_process

from sandbox.projects.common.gencfg import utils as config_generator_utils
from sandbox.projects.common.gencfg.task import IGencfgReleaseTask


class ReleaseConfigGeneratorService(IGencfgReleaseTask):
    type = 'RELEASE_CONFIG_GENERATOR_SERVICE'

    @property
    def footer(self):
        return self.ctx.get('result')

    def on_execute(self):
        self.check_running_tasks()

        config_generator_utils.clone_gencfg_all(self.get_src_path(), 'full')

        if not self.need_new_tag([os.path.join(self.get_src_path(), 'custom_generators', 'balancer_gencfg')], "^service-stable-(\d+)-r(\d+)$"):
            return

        subargs = self.generate_create_tag_bash_command("backend")
        p = run_process(subargs, log_prefix='create_new_tag')

        self.release_built_tag(p.stdout_path)


__Task__ = ReleaseConfigGeneratorService
