# coding: utf-8

# $Header$

from sandbox.projects import resource_types

from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import process


class ReleaseCyCounterFiles(task.SandboxTask):
    type = 'RELEASE_CYCOUNTER_FILES'

    description = 'CyCounter files release, SEPE-7369, SEPE-7325'
    execution_space = 16

    SVN_PATH = 'arcadia:/arc/trunk/arcadia/yweb/webdaemons/resinfod/data/cycounter'

    def on_execute(self):
        svn.Arcadia.checkout(self.SVN_PATH, 'cycounter-files')
        svn_rev = self.ctx['svn_rev'] = svn.Arcadia.info('cycounter-files')['commit_revision']
        process.run_process(['tar', '-czf', 'cycounter-files.tar.gz', 'cycounter-files'], wait=True)
        self.create_resource(
            description='CyCounter files r' + svn_rev + ' (SEPE-7369, SEPE-7325)',
            resource_path='cycounter-files.tar.gz',
            resource_type=resource_types.CYCOUNTER_FILES,
            arch='any'
        )

    def arcadia_info(self):
        return self.ctx.get('svn_rev', 0), "trunk" + self.ctx.get('svn_rev', ''), 1


__Task__ = ReleaseCyCounterFiles
