# coding: utf-8

# $Header$

from sandbox.projects import resource_types
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.task import SandboxTask

svn_path = 'arcadia.yandex.ru:/arc/trunk/arcadia/yweb/urlrules/g2ld.list'


class ReleaseG2ld(SandboxTask):
    type = 'RELEASE_G2LD_LIST'

    description = 'G2ld list release, SEPE-7379, SEPE-7325'
    execution_space = 16

    def on_execute(self):
        g2ldlist = Arcadia.cat(svn_path)
        with open('g2ld.list', 'w') as f:
            f.write(g2ldlist)
        self.create_resource(
            description='g2ld list, SEPE-7379, SEPE-7325',
            resource_path='g2ld.list',
            resource_type=resource_types.G2LD_LIST,
            arch='any'
        )

    def arcadia_info(self):
        return 1, 1, 1


__Task__ = ReleaseG2ld
