# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import LastReleasedResource


class IssJdkPrestableResource(LastReleasedResource):
    name = 'jdk'
    description = 'jdk'
    resource_type = resource_types.ISS_JDK_PRESTABLE


class IssJnaPrestableResource(LastReleasedResource):
    name = 'jna'
    description = 'jna'
    resource_type = resource_types.ISS_JNA_PRESTABLE


class IssCassandraPrestableResource(LastReleasedResource):
    name = 'Cassandra'
    description = 'Cassandra'
    resource_type = resource_types.ISS_CASSANDRA_PRESTABLE


class IssJolokiaPrestableResource(LastReleasedResource):
    name = 'Jolokia'
    description = 'Jolokia'
    resource_type = resource_types.ISS_JOLOKIA_PRESTABLE


class IssCassandraConfigPrestableResource(LastReleasedResource):
    name = 'Cassandra_Config'
    description = 'Cassandra config'
    resource_type = resource_types.ISS_CASSANDRA_CONFIG_PRESTABLE


class IssCacherPrestableResource(LastReleasedResource):
    name = 'Cacher'
    description = 'Cacher'
    resource_type = resource_types.ISS_CACHER_PRESTABLE


class IssCacherConfigPrestableResource(LastReleasedResource):
    name = 'Cacher_Config'
    description = 'Cacher config'
    resource_type = resource_types.ISS_CACHER_CONFIG_PRESTABLE


class ReleaseIssPrestable(SandboxTask):
    type = 'RELEASE_ISS_PRESTABLE'

    input_parameters = [
        IssJdkPrestableResource,
        IssJnaPrestableResource,
        IssCassandraPrestableResource,
        IssJolokiaPrestableResource,
        IssCassandraConfigPrestableResource,
        IssCacherPrestableResource,
        IssCacherConfigPrestableResource
    ]

    def on_execute(self):
        current_dir = os.getcwd()

        jdk_path = self.sync_resource(self.ctx[IssJdkPrestableResource.name])
        shutil.copy(jdk_path, current_dir)
        self.create_resource('jdk', os.path.basename(jdk_path), resource_types.ISS_JDK_PRESTABLE, arch='any')

        jna_path = self.sync_resource(self.ctx[IssJnaPrestableResource.name])
        shutil.copy(jna_path, current_dir)
        self.create_resource('jna', os.path.basename(jna_path), resource_types.ISS_JNA_PRESTABLE, arch='any')

        cassandra_path = self.sync_resource(self.ctx[IssCassandraPrestableResource.name])
        shutil.copy(cassandra_path, current_dir)
        self.create_resource('Cassandra', os.path.basename(cassandra_path), resource_types.ISS_CASSANDRA_PRESTABLE, arch='any')

        jolokia_path = self.sync_resource(self.ctx[IssJolokiaPrestableResource.name])
        shutil.copy(jolokia_path, current_dir)
        self.create_resource('Jolokia', os.path.basename(jolokia_path), resource_types.ISS_JOLOKIA_PRESTABLE, arch='any')

        cassandra_conf_path = self.sync_resource(self.ctx[IssCassandraConfigPrestableResource.name])
        cassandra_conf_basename = os.path.basename(cassandra_conf_path)
        shutil.copytree(cassandra_conf_path, os.path.join(current_dir, cassandra_conf_basename))
        self.create_resource('Cassandra config', cassandra_conf_basename, resource_types.ISS_CASSANDRA_CONFIG_PRESTABLE,
                             arch='any')

        cacher_path = self.sync_resource(self.ctx[IssCacherPrestableResource.name])
        shutil.copy(cacher_path, current_dir)
        self.create_resource('Cacher', os.path.basename(cacher_path), resource_types.ISS_CACHER_PRESTABLE, arch='any')

        cacher_conf_path = self.sync_resource(self.ctx[IssCacherConfigPrestableResource.name])
        cacher_conf_basename = os.path.basename(cacher_conf_path)
        shutil.copytree(cacher_conf_path, os.path.join(current_dir, cacher_conf_basename))
        self.create_resource('Cacher config', cacher_conf_basename, resource_types.ISS_CACHER_CONFIG_PRESTABLE, arch='any')


__Task__ = ReleaseIssPrestable
