# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects.images.resources import task as resources_task


class NannyService(SandboxStringParameter):
    name = 'nanny_service_name'
    description = 'Nanny service name'
    required = True


class ReleaseNannyShardmap(SandboxTask, resources_task.ImagesProductionResourcesTask):
    """
        Релиз шардмапа из няни
    """

    input_parameters = [NannyService]

    type = "RELEASE_NANNY_SHARDMAP"

    def on_execute(self):
        shardmap_data = self._get_nanny_shard_map_data(self.ctx.get(NannyService.name))
        self.create_release(shardmap_data['task_id'], status='stable')


__Task__ = ReleaseNannyShardmap
