# -*- coding: utf-8 -*-

import logging

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel


class ReleaseStatus(SandboxStringParameter):
    name = 'release_status'
    description = 'release_type'
    choices = [
        ('stable', 'stable'),
        ('prestable', 'prestable'),
        ('testing', 'testing'),
        ('unstable', 'unstable'),
    ]
    required = True


logger = logging.getLogger(__name__)


class ReleaseParentTask(SandboxTask):
    """
        Релиз родительского таска
    """

    type = 'RELEASE_PARENT_TASK'
    execution_space = 128
    input_parameters = [ReleaseStatus]

    def on_execute(self):
        parent_task = channel.sandbox.get_task(self.parent_id)
        if not parent_task.is_done():
            self.wait_task_completed(parent_task.id)
        logger.debug('Parent status: {}'.format(parent_task.new_status))
        if parent_task.new_status == self.Status.SUCCESS:
            self.create_release(self.parent_id, status=self.ctx['release_status'])


__Task__ = ReleaseParentTask
