#!/usr/bin/env python
# -*- coding: utf-8 -*-

from sandbox.projects.common.build import YaMake, parameters as build_params
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common import constants
from sandbox.projects import resource_types
from sandbox.sandboxsdk import paths

import os
import shutil


class ReleaseQuickRearrangeData(nanny.ReleaseToNannyTask, YaMake.YaMakeTask):
    """
        Task for build data for rearrange rules that used on QUICK middlesearch
    """

    type = "RELEASE_QUICK_REARRANGE_DATA"

    input_parameters = (build_params.ArcadiaUrl,)

    def on_execute(self):
        self.ctx[constants.ARCADIA_URL_KEY] = self.ctx[build_params.ArcadiaUrl.name]
        self.ctx["targets"] = resource_types.QUICK_REARRANGE_RULES_DATA.arcadia_build_path
        self.ctx[build_params.TestCustomParameters.name] = True

        YaMake.YaMakeTask.on_execute(self)

    def post_build(self, source_dir, output_dir, pack_dir):
        YaMake.YaMakeTask.post_build(self, source_dir, output_dir, pack_dir)

        data_dir_name = "data"
        paths.make_folder(data_dir_name)

        build_prefix = os.path.join(output_dir, self.ctx["targets"])
        for item in os.listdir(build_prefix):
            if not (item.startswith(".") or item == "tests"):
                shutil.copytree(os.path.join(build_prefix, item), os.path.join(data_dir_name, item))

        resource = self.create_resource(
            description="Rearrange data for QUICK middlesearch, build from task #{}, {}".format(self.id, self.descr),
            resource_path=data_dir_name,
            resource_type=resource_types.QUICK_REARRANGE_RULES_DATA,
        )
        self.mark_resource_ready(resource.id)


__Task__ = ReleaseQuickRearrangeData
