#  -*- coding: utf-8 -*-

from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.common import apihelpers

import sandbox.projects.ReportDataRuntimeItem as RDRI
import sandbox.projects.ReportDataRuntime as RDR
import sandbox.projects.ReportDataRuntimeTags as Tags


class ReleaseReportDataRuntimeBundle(SandboxTask):
    """
    Создает бандл из нескольких версий data.runtime и релизит этот ресурс
    """

    type = 'RELEASE_REPORT_DATA_RUNTIME_BUNDLE'
    execution_space = 100
    input_parameters = [Tags.ApacheBundleParameter, RDRI.Project, Tags.NumberTags, Tags.NumberMinorTags, Tags.NumberBranches]

    def on_execute(self):
        if 'subtask_id' not in self.ctx:
            if self.ctx[Tags.NumberTags.name] <= 0:
                raise SandboxTaskFailureError('Bundle can create only from tags')

            # выставляем недостающие параметры
            if not self.ctx.get(Tags.ApacheBundleParameter.name):
                res = apihelpers.get_last_released_resource(Tags.ApacheBundleParameter.resource_type)
                if not res:
                    raise SandboxTaskFailureError("Can not find last stable resource %s" % Tags.ApacheBundleParameter.resource_type)
                self.ctx[Tags.ApacheBundleParameter.name] = res.id

            ctx = {
                RDRI.Project.name: self.ctx[RDRI.Project.name],
                Tags.NumberTags.name: self.ctx[Tags.NumberTags.name],
                Tags.NumberMinorTags.name: self.ctx[Tags.NumberMinorTags.name],
                Tags.NumberBranches.name: self.ctx[Tags.NumberBranches.name],
                Tags.CreateBundle.name: True,
                Tags.ApacheBundleParameter.name: self.ctx[Tags.ApacheBundleParameter.name]
            }

            # не делаем уведомления для дочерних задач
            ctx['notify_via'] = ''
            subtask = self.create_subtask(
                task_type=Tags.ReportDataRuntimeTags.type,
                description='Auto generate data.runtime bundle',
                input_parameters=ctx,
                important=self.important
            )
            self.ctx['subtask_id'] = subtask.id
            channel.sandbox.server.wait_time(self.id, RDR.ReportDataRuntime.time_to_wait + 120)
            self.wait_all_tasks_completed(subtask.id)
        else:
            # проверить что таск корректно отработал
            subtask = channel.sandbox.get_task(self.ctx['subtask_id'])
            if not subtask.is_finished():
                raise SandboxTaskFailureError('Subtask {0} failed with status: {1}.'.format(subtask.id, subtask.status))

            # релизим таск
            subject = "data.runtime for project %s" % self.ctx[RDRI.Project.name]
            # TODO добавить в subject из каких ресурсов собрали(revision,version,project)
            release = self.create_release(subtask.id, subject=subject)
            if not release:
                raise SandboxTaskFailureError('Cannot release task {task_id}.'.format(task_id=subtask.id))


__Task__ = ReleaseReportDataRuntimeBundle
