#  -*- coding: utf-8 -*-

from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.common import apihelpers

import sandbox.projects.ReportDataRuntimeItem as RDRI
import sandbox.projects.ReportDataRuntime as RDR
import sandbox.projects.ReportDataRuntimeLastTag as LastTag
import sandbox.projects.report.common as report_common


class ReleaseReportDataRuntimeBundle2(SandboxTask):
    """
    Создает бандл из нескольких версий data.runtime и релизит этот ресурс
    """

    type = 'RELEASE_REPORT_DATA_RUNTIME_BUNDLE2'
    execution_space = 100
    input_parameters = [report_common.ApacheBundleParameter, RDRI.Project, RDR.CacheSources, RDR.ForceUpdateSources]

    def on_execute(self):
        if 'subtask_id' not in self.ctx:
            # выставляем недостающие параметры
            if not self.ctx.get(report_common.ApacheBundleParameter.name):
                res = apihelpers.get_last_released_resource(report_common.ApacheBundleParameter.resource_type)
                if not res:
                    raise SandboxTaskFailureError(
                        "Can not find last stable resource {}".format(report_common.ApacheBundleParameter.resource_type)
                    )
                self.ctx[report_common.ApacheBundleParameter.name] = res.id

            ctx = {
                RDRI.Project.name: self.ctx[RDRI.Project.name],
                report_common.ApacheBundleParameter.name: self.ctx[report_common.ApacheBundleParameter.name],
                RDR.CacheSources.name: self.ctx[RDR.CacheSources.name],
                RDR.ForceUpdateSources.name: self.ctx[RDR.ForceUpdateSources.name]
            }

            # не делаем уведомления для дочерних задач
            ctx['notify_via'] = ''
            subtask = self.create_subtask(
                task_type=LastTag.ReportDataRuntimeLastTag.type,
                description='Auto generate data.runtime bundle',
                input_parameters=ctx,
                important=self.important
            )
            self.ctx['subtask_id'] = subtask.id
            channel.sandbox.server.wait_time(self.id, RDR.ReportDataRuntime.time_to_wait + 120)
            self.wait_all_tasks_completed(subtask.id)
        else:
            # проверить что таск корректно отработал
            subtask = channel.sandbox.get_task(self.ctx['subtask_id'])
            if not subtask.is_finished():
                raise SandboxTaskFailureError('Subtask {0} failed with status: {1}.'.format(subtask.id, subtask.status))

            # релизим таск
            subject = "data.runtime for project %s" % self.ctx[RDRI.Project.name]
            # TODO добавить в subject из каких ресурсов собрали(revision,version,project)
            release = self.create_release(subtask.id, subject=subject)
            if not release:
                raise SandboxTaskFailureError('Cannot release task {task_id}.'.format(task_id=subtask.id))


__Task__ = ReleaseReportDataRuntimeBundle2
