# coding: utf-8

from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.common.nanny.auto_deploy import AutoNannyDeployTask


class SvnUrlParameter(SandboxStringParameter):
    name = 'svn_url'
    description = 'Svn url'
    default_value = 'arcadia:robots/trunk/genconf/UPPER/shard_scripts_autoshard'


class ReleaseShardInstallScripts(AutoNannyDeployTask, SandboxTask):
    """
        Выкачиваем скрипты из svn, сохраняем как ресурсы
    """

    type = 'RELEASE_SHARD_INSTALL_SCRIPTS'

    input_parameters = (SvnUrlParameter, )

    def on_execute(self):
        svn_url_info = Arcadia.info(self.ctx['svn_url'])
        revision = svn_url_info['entry_revision']
        Arcadia.export(svn_url_info['url'], self.abs_path(), revision)

        self.create_resource(self.descr, self.path('shard.conf'), resource_types.SHARD_CONF)
        self.create_resource(self.descr, self.path('install.py'), resource_types.SHARD_INSTALL_SCRIPT)
        self.create_resource(self.descr, self.path('installer.py'), resource_types.SHARD_INSTALLER_SCRIPT)

    def arcadia_info(self):
        parsed_url = Arcadia.parse_url(self.ctx['svn_url'])
        fake_tag = parsed_url.path.split('/')[-1]
        return parsed_url.revision, fake_tag, None


__Task__ = ReleaseShardInstallScripts
