# -*- coding: utf-8 -*-


import logging

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.errors import SandboxTaskFailureError

from sandbox.projects.sandbox.remote_copy_resource import RemoteCopyResource


class ReleaseDescription(SandboxStringParameter):
    name = 'release_description'
    description = 'Release description'
    multiline = True
    default_value = 'New shard for smisearch'


class ReleaseSmisearchShard(SandboxTask):

    type = 'RELEASE_SMISEARCH_SHARD'

    execution_space = 1000

    input_parameters = [ReleaseDescription] + RemoteCopyResource.input_parameters

    def on_execute(self):
        if not self.ctx.get('upload_task'):
            logging.info('Creating shard upload task...')
            upload_task = self.create_subtask(
                task_type='UPLOAD_SMISEARCH_SHARD',
                description='Upload shard from news indexer'
            )
            self.ctx['upload_task'] = upload_task.id
            self.wait_task_completed(upload_task)
        else:
            upload_task = channel.sandbox.get_task(self.ctx['upload_task'])
            if upload_task.is_finished():
                release = self.create_release(upload_task.id,
                                              status='stable',
                                              subject='Smisearch shard',
                                              comments=None,
                                              changelog=None,
                                              addresses_to='news-releases@yandex-team.ru')
                if not release:
                    raise SandboxTaskFailureError('Cannot release task {task_id}.'.format(
                                                  task_id=upload_task.id
                                                  ))
            else:
                raise SandboxTaskFailureError('Shard upload task {task_id} was not completed correctly.'.format(
                    task_id=upload_task.id
                ))


__Task__ = ReleaseSmisearchShard
