# coding: utf-8

import logging
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter, SandboxBoolParameter
from sandbox.projects.common.nanny.auto_deploy import AutoNannyDeployTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.channel import channel


class CheckWizardDataParameter(SandboxBoolParameter):
    name = 'check_wizard_data'
    description = 'Check wizard data before commit'
    default_value = True


class YtOauthVaultName(SandboxStringParameter):
    name = 'yt_oauth_vault_name'
    description = 'YT oauth key vault name'
    default_value = ''


class TvmSecretVaultName(SandboxStringParameter):
    name = 'tvm_secret_vault_name'
    description = 'TVM secret vault name'
    default_value = ''


class ReleaseSportProxyData(AutoNannyDeployTask, SandboxTask):
    """
        Собирает sport_proxy.datа и делает релиз
    """

    type = 'RELEASE_SPORT_PROXY_DATA'

    input_parameters = (CheckWizardDataParameter, YtOauthVaultName, TvmSecretVaultName, )

    def on_execute(self):
        if not self.ctx.get('build_task'):
            logging.info('Create build sport_proxy.data task.')
            build_task = self.create_subtask(
                task_type='BUILD_SPORT_PROXY_DATA',
                description='build last revision of sport_proxy.data from svn',
                execution_space=5000,
                input_parameters={
                    'check_wizard_data': self.ctx['check_wizard_data'],
                    'yt_oauth_vault_name': self.ctx['yt_oauth_vault_name'],
                    'tvm_secret_vault_name': self.ctx['tvm_secret_vault_name'],
                },
            )
            self.ctx['build_task'] = build_task.id
            self.wait_all_tasks_stop_executing([build_task])
        else:
            build_task = channel.sandbox.get_task(self.ctx['build_task'])
            if build_task.is_failure():
                raise SandboxTaskFailureError('BuildSportProxyData task {task_id} was failed.'.format(
                    task_id=build_task.id
                ))
            if build_task.is_finished():
                release = self.create_release(
                    build_task.id,
                    subject="sport_proxy.data release",
                    addresses_to="ustas@yandex-team.ru")

                if not release:
                    raise SandboxTaskFailureError(
                        'Cannot release task {task_id}.'.format(task_id=build_task.id))
            else:
                raise SandboxTaskFailureError(
                    'BuildSportProxyData task {task_id} was not completed correctly.'.format(task_id=build_task.id))


__Task__ = ReleaseSportProxyData
