# coding: utf-8

from sandbox import sdk2
from sandbox import common
import sandbox.common.types.task as ctt

from sandbox.common.types.task import ReleaseStatus


class TaskTypeParameter(sdk2.parameters.String):
    @common.utils.classproperty
    def choices(self):
        return sorted((t_type, t_type) for t_type in common.projects_handler.load_project_types(reuse=True))


class ReleaseTask(sdk2.Task):
    """
        Релиз задачи
    """
    class Parameters(sdk2.Task.Parameters):
        task_type = TaskTypeParameter("Task Type", required=True)

    def on_execute(self):
        task_type = self.Parameters.task_type

        with self.memoize_stage.launch_subtask:
            self.set_info('Create build task...')
            subtask = sdk2.Task[task_type]
            launch = subtask(
                self,
                owner=self.owner
            ).enqueue()

            raise sdk2.WaitTask(
                [launch],
                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK
            )
        build_task = self.find(children=True).first()
        if build_task.status != ctt.Status.SUCCESS:
            raise common.errors.TaskError('Build dcron scripts task {type}, ID: {task_id} was failed.'.format(
                type=task_type,
                task_id=build_task.id
            ))
        else:
            self.set_info('Create release...')

            self.server.release(
                task_id=build_task.id,
                type=ReleaseStatus.STABLE,
                subject="Release"
            )
