# coding: utf-8

import logging
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class ReleaseVideoVegasConfig(SandboxTask):
    """
        Релиз конфигов вегаса
    """
    type = 'RELEASE_VIDEO_VEGAS_CONFIG'

    def on_execute(self):
        if not self.ctx.get('build_id'):
            logging.info('Create build task...')
            build_task = self.create_subtask(
                task_type='VIDEO_BUILD_VEGAS_CONFIG',
                description='Release vegas configs',
            )
            self.ctx['build_id'] = build_task.id
            self.wait_task_completed(build_task)
        else:
            build_task = channel.sandbox.get_task(self.ctx['build_id'])
            if build_task.is_failure():
                raise SandboxTaskFailureError('Build dcron scripts task {task_id} was failed.'.format(
                    task_id=build_task.id
                ))
            elif build_task.is_finished():
                logging.info('Create release...')
                release = self.create_release(
                    build_task.id,
                    subject='Release vegas configs: svn {revision}'.format(revision=build_task.ctx.get('svn_revision', 'unknown')),
                    addresses_to='matveieff@yandex-team.ru',
                )

                if not release:
                    raise SandboxTaskFailureError('Cannot release task {task_id}.'.format(
                        task_id=build_task.id
                    ))
            else:
                raise SandboxTaskFailureError(
                    'Release video vegas config task {task_id} was not completed correctly.'.format(
                        task_id=build_task.id
                    )
                )


__Task__ = ReleaseVideoVegasConfig
