# coding: utf-8
import logging
import shutil
import tarfile
import uuid
import os

from sandbox.common.types.client import Tag
from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.task import SandboxTask


class ReleaseYtLocal(nanny.ReleaseToNannyTask, SandboxTask):
    """
    Тестовая задача по релизу YT_LOCAL
    """
    type = 'RELEASE_YT_LOCAL'

    client_tags = Tag.LINUX_PRECISE
    cores = 1

    input_parameters = [
        nanny.StartrekTicketIdsParameter
    ]

    environment = []

    # https://sandbox.yandex-team.ru/resource/185265633/view
    RESOURCE_ID = 185265633

    def arcadia_info(self):
        """
        Hacky way to allow this task to be released: provide tag, other fields are not checked.
        """
        return None, self.ctx.get('tag'), None

    def on_execute(self):
        path = self.sync_resource(self.RESOURCE_ID)
        logging.info('Got: %s', path)
        new_path = self.path('yt_local.tar')
        shutil.copy(path, new_path)

        randomize_path = self.path('randomize.txt')
        with open(randomize_path, 'w') as f:
            f.write(str(uuid.uuid4()))
        os.chmod(new_path, 0664)
        with tarfile.open(new_path, 'a') as f:
            f.add(randomize_path)

        self.create_resource(
            description='Reshared {}'.format(self.RESOURCE_ID),
            resource_path=new_path,
            resource_type=resource_types.YT_LOCAL_TEST,
            arch='linux'
        )

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = ReleaseYtLocal
