#  -*- coding: utf-8 -*-

import sandbox.projects.report.common as report_common
import sandbox.projects.ReportDataRuntime as RDR
import sandbox.projects.ReportDataRuntimeItem as RDRI
import sandbox.projects.ReportDataRuntimeTags as RDRT


class ReportDataRuntimeLastTag(RDRT.ReportDataRuntimeTags):
    """
       Создает данные(data.runtime) для последнего мажорного тега (configuration=production)
    """

    type = 'REPORT_DATA_RUNTIME_LAST_TAG'
    execution_space = 3000
    input_parameters = [report_common.ApacheBundleParameter, RDRI.Project, RDR.CacheSources, RDR.ForceUpdateSources]

    def on_execute(self):
        self.ctx[RDRT.NumberTags.name] = 1
        self.ctx[RDRT.NumberMinorTags.name] = 1
        self.ctx[RDRT.NumberBranches.name] = 0
        self.ctx[RDRT.CreateBundle.name] = 1
        super(ReportDataRuntimeLastTag, self).on_execute()

    def modify_task_ctx(self, task_ctx):
        for (ctx, is_tag) in task_ctx:
            if self.ctx[RDR.CacheSources.name]:
                ctx[RDR.CacheSources.name] = self.ctx[RDR.CacheSources.name]
            if self.ctx[RDR.ForceUpdateSources.name]:
                ctx[RDR.ForceUpdateSources.name] = self.ctx[RDR.ForceUpdateSources.name]

    def on_release(self, params):
        super(ReportDataRuntimeLastTag, self).on_release(params)

        if 'ttl' in params.keys():
            self.mark_released_resources(params["release_status"], ttl=params["ttl"])


__Task__ = ReportDataRuntimeLastTag
