# -*- coding: utf-8 -*-

import time
import collections

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.common import apihelpers


class ReshareShards(SandboxTask):
    type = 'RESHARE_SHARDS'

    def on_execute(self):
        resource_types = [
            'REARRANGE_SHARD',
            'YASMAGENT_SHARD',
            'JAVA_SHARD'
        ]

        to_reshare = collections.defaultdict(list)
        for resource_type in resource_types:
            resources = apihelpers.get_resources_with_attribute(resource_type, status='READY')
            if resources is not None:
                for res in resources:
                    if self.older_than_day(res):
                        break
                    real_resource = self._read_resource(res.id, sync=False)
                    for host in real_resource.get_hosts():
                        to_reshare[host].append(str(res.id))

        for (host, resources) in to_reshare.iteritems():
            res = ', '.join(resources)
            descr = 'reshare: %s' % res
            ctx = {'resources': res}
            self.create_subtask('RESHARE_SHARDS_ON_HOST', descr, input_parameters=ctx, host=host)

    def older_than_day(self, res):
        return res.timestamp < time.time() - 24 * 60 * 60


__Task__ = ReshareShards
