# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import parameters as sp
from sandbox.projects import resource_types
from sandbox.projects.common.base_search_quality import settings as bss

import shutil
import os


class Database(sp.ResourceSelector):
    name = 'database_resource_id'
    description = 'Database'
    resource_type = [
        resource_types.SEARCH_DATABASE,
    ]


class RestoreIndexfrq(SandboxTask):
    """
        Temporary task to restore original indexfrq in search database.
        Will use to compare search performance with and without aspam applied.
    """

    type = 'RESTORE_INDEXFRQ'
    execution_space = bss.MAX_BASE_SHARD_SIZE + bss.RESERVED_SPACE
    input_parameters = (Database,)

    def on_enqueue(self):
        self.ctx['restored_db'] = self.create_resource(
            '{} indexfrq.orig'.format(self.ctx[Database.name]),
            'db.indexfrq.orig',
            resource_types.SEARCH_DATABASE,
            arch='any'
        ).id

    def on_execute(self):
        db = self.sync_resource(self.ctx[Database.name])
        restored_db = channel.sandbox.get_resource(self.ctx['restored_db'])

        if os.path.isdir(restored_db.path):
            shutil.rmtree(restored_db.path)
        shutil.copytree(db, restored_db.path)
        os.chmod(os.path.join(restored_db.path, 'indexfrq'), 0777)
        shutil.copy(os.path.join(restored_db.path, 'indexfrq.orig'), os.path.join(restored_db.path, "indexfrq"))
        self.mark_resource_ready(restored_db)


__Task__ = RestoreIndexfrq
