# -*- coding: utf-8 -*-


from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter, ResourceSelector
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.environments import MongodbEnvironment
from sandbox.projects.common.apihelpers import get_last_resource_with_attribute


class MongoHostParameter(SandboxStringParameter):
    name = 'mongo_host'
    description = 'Host with mongo db'


class MongoDbParameter(SandboxStringParameter):
    name = 'mongo_db'
    description = 'Database name'


class MongoAdditionalParametr(SandboxStringParameter):
    name = 'mongo_additional'
    description = 'Additional parameters to mongo client'
    default_value = ''


class DumpParameter(ResourceSelector):
    name = 'dump'
    description = 'Dump resource (leave empty for last suitable resource)'
    resource_type = resource_types.MONGO_DB_DUMP
    default_value = None


class RestoreMongo(SandboxTask):
    """
    Восстановить базу mongo из бекапа.
    """

    type = 'RESTORE_MONGO'

    input_parameters = [MongoHostParameter, MongoDbParameter,
                        MongoAdditionalParametr, DumpParameter]

    environment = (
        MongodbEnvironment(),
    )

    def on_execute(self):
        if not self.ctx[DumpParameter.name]:
            self.ctx[DumpParameter.name] = get_last_resource_with_attribute(resource_types.MONGO_DB_DUMP,
                                                                            'db', self.ctx[MongoDbParameter.name]).id
        dump_path = self.sync_resource(self.ctx[DumpParameter.name])
        cmd = ['mongorestore',
               '--host',
               self.ctx[MongoHostParameter.name],
               dump_path]
        run_process(cmd, log_prefix='mongo_restore')


__Task__ = RestoreMongo
