# -*- coding: utf-8 -*-
import os

from sandbox.projects.RunScript import RunScript
from sandbox.sandboxsdk import parameters as sp
from sandbox.sandboxsdk import process


class RunDiskPythonScript(RunScript):
    '''
    Run arbitrary python script by specified python/virtualenv with specified resource as argument
    '''

    type = 'RUN_DISK_PYTHON_SCRIPT'

    cores = 1
    required_ram = 4096
    disk_space = 4024

    class DiskContainer(sp.Container):
        name = 'Container resource ID'
        description = 'LXC Container w/ all needed stuff to run disk related jobs'
        default_value = 541990849
        required = True

    input_parameters = [DiskContainer] + RunScript.input_parameters

    def get_cmdline(self, scriptdir):
        cmdline = RunScript.get_cmdline(self, scriptdir)
        process.run_process(
            ['pip', 'install',
             '--user',
             '-i', 'https://pypi.yandex-team.ru/simple/',
             '-U',
             '-r', os.path.join(scriptdir, os.path.dirname(cmdline), 'requirements.txt')
             ],
            log_prefix='pip_install', shell=True
        )
        return 'python %s' % cmdline


__Task__ = RunDiskPythonScript
