# -*- coding: utf-8 -*-

from sandbox.projects.common.search import idx_ops
from sandbox.projects.common.base_search_quality import settings as bss
from sandbox.projects import resource_types


class RunIdxOps(idx_ops.BaseGetIdxOpsResponses):
    """
        Запускает утилиту `idx_ops` на указанных базе данных и запросах в режиме `serp`.
        Вывод утилиты сохраняется для дальнейшего анализа (изменения факторов, etc).
        `Описание idx_ops <https://wiki.yandex-team.ru/Development/Poisk/arcadia/search/tools/idxops>`_.
    """

    type = 'RUN_IDX_OPS'

    execution_space = bss.RESERVED_SPACE

    idx_ops_serp_args = ['-g', 'domain', '--printdocid']

    input_parameters = idx_ops.create_input_parameters(
        resource_types.IDX_OPS_EXECUTABLE,
        resource_types.SEARCH_DATABASE
    ).params + idx_ops.BaseGetIdxOpsResponses.input_parameters


__Task__ = RunIdxOps
