# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters
import json
import collections
import time
from sandbox import common


def LoadJSON(path):
    return json.load(file(path, "rt"), object_pairs_hook=collections.OrderedDict)


class Task(sdk_task.SandboxTask):

    class NivranaTokenName(sdk_parameters.SandboxStringParameter):
        name = "nirvana_token"
        description = "Vault with Nirvana Token"

    class TestNamePrefix(sdk_parameters.SandboxStringParameter):
        name = "test_name"
        description = "Common name prefix for tests"

    class NirvanaQuota(sdk_parameters.SandboxStringParameter):
        name = "nirvana_quota"
        description = "Nirvana quota"

    class NirvanaWorkflowTestId(sdk_parameters.SandboxStringParameter):
        name = "nirvana_workflow_test_id"
        description = "Nirvana workflow id for test"

    type = "RUN_NIRVANA_BASED_INTEGRATION_TEST"
    input_parameters = [
        NivranaTokenName,
        TestNamePrefix,
        NirvanaQuota,
        NirvanaWorkflowTestId,
    ]

    def MakeStartrekComment(self,
        startrek_api_token, ticket_id,
        new_mr_ms_op_id, new_mr_local_op_id, new_tsv_ms_op_id, new_tsv_local_op_id,
        mr_ms_wfid, mr_local_wfid, tsv_ms_wfid, tsv_local_wfid):

        import startrack_api
        import get_file_strategy
        import get_file

        def make_url_for_operation(opid):
            return "https://nirvana.yandex-team.ru/operation/{0}/overview".format(opid)

        def make_url_for_wf(wfid):
            return "https://nirvana.yandex-team.ru/flow/{0}/graph".format(wfid)

        comment_helper = startrack_api.Comments(ticket_id, startrek_api_token, get_file_strategy=get_file_strategy.return_get_file_class(get_file.GetFile))
        logging.info(comment_helper.POST("TODO: add test execution info"))

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/tools/mstand/nirvana_api"))
        import nirvana_api
        # import nirvana_workflow_helper

        nv_token = self.get_vault_data(self.ctx.get(self.NivranaTokenName.name))
        name_prefix = self.ctx.get(self.TestNamePrefix.name)

        NIRVANA_BASED_INTEGRATION_TEST_WORKFLOW = self.ctx.get(self.NirvanaWorkflowTestId.name)
        QUOTA_NAME = self.ctx.get(self.NirvanaQuota.name)

        source_wfid = "https://nirvana.yandex-team.ru/flow/{}/graph".format(NIRVANA_BASED_INTEGRATION_TEST_WORKFLOW)

        n_api_orig = nirvana_api.NirvanaAPI(NIRVANA_BASED_INTEGRATION_TEST_WORKFLOW, nv_token)
        n_api = n_api_orig.CloneThisWorkflow(name_prefix + ' integration test', new_quota_project_id=QUOTA_NAME)
        n_api.EditWorkflowSkipPermissions()
        try:
            n_api.UpdateOperationBlocks()
        except Exception as ex:
            msg = "UpdateOperationBlocks returns the following error: " + str(ex) + "\nTry to update the source workflow: " + source_wfid
            raise common.errors.TaskFailure(msg)

        n_api.StartWorkflow()

        message = "Starting workflow {} with test.".format(n_api.wfId)
        logging.info(message)

        need_to_fail = False
        while True:
            try:
                progress = dict(n_api.GetExecutionState()['result'])
                print progress
                if progress['status'] == 'completed':
                    if progress['result'] != 'success':
                        sys.stderr.write('Nirvana workflow has failed. Recreate it.\n')
                        need_to_fail = True
                    break
            except:
                logging.info('Failed to execute GetExecutionState')
            time.sleep(60)

        if need_to_fail:
            raise common.errors.TaskFailure(
                'Test has completed with no success. See https://nirvana.yandex-team.ru/flow/{}/graph'.format(n_api.wfId)
                )


__Task__ = Task
