# -*- coding: utf-8 -*-

import os

from sandbox.sandboxsdk import parameters as sp
from sandbox.sandboxsdk import errors as se
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.environments import VirtualEnvironment

from sandbox.projects.RunScript import RunScript
from sandbox.projects import resource_types


class RunPythonFromWheel(RunScript):
    '''
    Run arbitrary python script from given wheel
    '''

    type = 'RUN_PYTHON_FROM_WHEEL'

    class WheelResourceType(sp.SandboxStringParameter):
        name = 'wheel_resource_type'
        description = 'wheel resource type'
        default_value = str(resource_types.PYTHON_WHEEL)

    class WheelResource(sp.ResourceSelector):
        name = 'wheel_resource'
        description = 'wheel resource (leave empty to resolve by type)'

    input_parameters = [WheelResourceType,
                        WheelResource] + RunScript.input_parameters

    def on_execute(self):
        resid = self.ctx[self.WheelResource.name]
        if not resid:
            rtype = self.ctx[self.WheelResourceType.name]
            if rtype:
                rlist = channel.sandbox.list_resources(
                    resource_type=rtype,
                    omit_failed=True,
                    limit=1,
                    arch=self.client_info['arch'],
                    order_by='-id'
                )
                if not len(rlist):
                    raise se.SandboxTaskFailureError("Didn't find any stable-released resource of type %s" % rtype)
                resid = rlist[0]

        respath = self.sync_resource(resid)
        if os.path.isdir(respath):
            wheels = [file for file in os.listdir(respath) if file.endswith('.whl')]
            if not wheels:
                raise se.SandboxTaskFailureError("Couldn't find wheel in specified resource")

            wheel = respath + '/' + wheels[0]
        else:
            wheel = respath

        with VirtualEnvironment() as venv:
            venv.pip('-U pip')
            venv.pip(wheel)
            return RunScript.on_execute(self)


__Task__ = RunPythonFromWheel
